/*
 * Decompiled with CFR 0.152.
 */
package io.lighty.core.cluster.config;

import com.typesafe.config.Config;
import com.typesafe.config.ConfigFactory;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class ClusteringConfigUtils {
    private static final Logger LOG = LoggerFactory.getLogger(ClusteringConfigUtils.class);
    public static final String MODULE_SHARDS_TMP_PATH = "/tmp/module-shards.conf";
    public static final String K8S_POD_RESTART_TIMEOUT_PATH = "akka.lighty-kubernetes.pod-restart-timeout";

    private ClusteringConfigUtils() {
    }

    public static String generateModuleShardsForMembers(List<String> memberRoles) {
        return String.format("module-shards = [%n%s]", String.join((CharSequence)",\n", ClusteringConfigUtils.generateShard("default", memberRoles), ClusteringConfigUtils.generateShard("topology", memberRoles), ClusteringConfigUtils.generateShard("inventory", memberRoles)));
    }

    public static boolean isKubernetesDeployment(Config actorSystemConfig) {
        return actorSystemConfig.hasPath("akka.discovery.method") && actorSystemConfig.getString("akka.discovery.method").equalsIgnoreCase("kubernetes-api");
    }

    private static String generateShard(String name, List<String> replicas) {
        return "    {        name = \"" + name + "\"\n        shards = [\n            {\n                name=\"" + name + "\"\n                replicas = " + replicas + "                \n            }\n        ]\n    }";
    }

    public static Config getModuleShardsConfigForMember(List<String> memberRoles) {
        LOG.info("Generating Module-Shards CONFIG");
        return ConfigFactory.parseString((String)ClusteringConfigUtils.generateModuleShardsForMembers(memberRoles));
    }
}

