/*
 * Decompiled with CFR 0.152.
 */
package io.lighty.core.cluster;

import com.typesafe.config.Config;
import io.lighty.core.cluster.ClusteringHandler;
import io.lighty.core.cluster.kubernetes.KubernetesClusteringHandlerImpl;
import java.util.Optional;
import org.eclipse.jdt.annotation.NonNull;
import org.opendaylight.controller.cluster.ActorSystemProvider;

public final class ClusteringHandlerProvider {
    private ClusteringHandlerProvider() {
    }

    public static Optional<ClusteringHandler> getClusteringHandler(@NonNull ActorSystemProvider actorSystemProvider, @NonNull Config akkaDeploymentConfig) {
        String clusteringTool;
        if (akkaDeploymentConfig.hasPath("akka.discovery.method") && "kubernetes-api".equals(clusteringTool = akkaDeploymentConfig.getString("akka.discovery.method"))) {
            return Optional.of(new KubernetesClusteringHandlerImpl(actorSystemProvider, akkaDeploymentConfig));
        }
        return Optional.empty();
    }
}

