/*
 * Decompiled with CFR 0.152.
 */
package io.labs.dotanuki.timeouts_enforcer.domain;

import io.labs.dotanuki.timeouts_enforcer.domain.AcceptedDurations;
import io.labs.dotanuki.timeouts_enforcer.domain.TimeoutEnforcerException;
import java.time.Duration;
import java.time.temporal.ChronoUnit;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\"\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u00c0\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u001c\u0010\n\u001a\u00020\u000b2\u0014\u0010\f\u001a\u0010\u0012\u0004\u0012\u00020\u0004\u0012\u0006\u0012\u0004\u0018\u00010\u00010\rJ\u0010\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0004H\u0002J&\u0010\u0011\u001a\u00020\u00042\u0014\u0010\f\u001a\u0010\u0012\u0004\u0012\u00020\u0004\u0012\u0006\u0012\u0004\u0018\u00010\u00010\r2\u0006\u0010\u0012\u001a\u00020\u0004H\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00040\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00040\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u00040\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0013"}, d2={"Lio/labs/dotanuki/timeouts_enforcer/domain/ProjectPropertiesParser;", "", "()V", "DURATION_PER_BUILD", "", "DURATION_PER_TASK", "SPEC_HOURS", "", "SPEC_MINUTES", "SPEC_SECONDS", "extractDurations", "Lio/labs/dotanuki/timeouts_enforcer/domain/AcceptedDurations;", "properties", "", "parseDuration", "Ljava/time/Duration;", "durationSpec", "safeExtractProperty", "propertyName", "timeouts-enforcer-plugin"})
public final class ProjectPropertiesParser {
    @NotNull
    public static final String DURATION_PER_TASK = "io.labs.dotanuki.enforcer.maxDurationPerTask";
    @NotNull
    public static final String DURATION_PER_BUILD = "io.labs.dotanuki.enforcer.maxDurationPerBuild";
    private static final Set<String> SPEC_SECONDS;
    private static final Set<String> SPEC_MINUTES;
    private static final Set<String> SPEC_HOURS;
    public static final ProjectPropertiesParser INSTANCE;

    @NotNull
    public final AcceptedDurations extractDurations(@NotNull Map<String, ? extends Object> properties) {
        Intrinsics.checkParameterIsNotNull(properties, (String)"properties");
        String taskSpec = this.safeExtractProperty(properties, DURATION_PER_TASK);
        String buildSpec = this.safeExtractProperty(properties, DURATION_PER_BUILD);
        return new AcceptedDurations(this.parseDuration(taskSpec), this.parseDuration(buildSpec));
    }

    private final String safeExtractProperty(Map<String, ? extends Object> properties, String propertyName) {
        Object object = properties.get(propertyName);
        if (!(object instanceof String)) {
            object = null;
        }
        String string = (String)object;
        if (string == null) {
            throw (Throwable)((Object)new TimeoutEnforcerException.MissingConfiguration(propertyName));
        }
        return string;
    }

    /*
     * WARNING - void declaration
     */
    private final Duration parseDuration(String durationSpec) {
        Object object;
        try {
            void amount;
            ChronoUnit chronoUnit;
            String duration;
            List list = CollectionsKt.take((Iterable)StringsKt.split$default((CharSequence)durationSpec, (String[])new String[]{"."}, (boolean)false, (int)0, (int)6, null), (int)2);
            Object object2 = list;
            boolean bl = false;
            object = (String)object2.get(0);
            object2 = list;
            bl = false;
            String string = duration = (String)object2.get(1);
            boolean bl2 = false;
            String string2 = string;
            if (string2 == null) {
                throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
            }
            String string3 = string2.toUpperCase();
            Intrinsics.checkExpressionValueIsNotNull((Object)string3, (String)"(this as java.lang.String).toUpperCase()");
            object2 = string3;
            if (SPEC_SECONDS.contains(object2)) {
                chronoUnit = ChronoUnit.SECONDS;
            } else if (SPEC_MINUTES.contains(object2)) {
                chronoUnit = ChronoUnit.MINUTES;
            } else if (SPEC_HOURS.contains(object2)) {
                chronoUnit = ChronoUnit.HOURS;
            } else {
                string = "Unsupported spec unit -> " + durationSpec;
                bl2 = false;
                throw (Throwable)new IllegalStateException(string.toString());
            }
            ChronoUnit unit = chronoUnit;
            object2 = amount;
            boolean bl3 = false;
            Duration duration2 = Duration.of(Long.parseLong((String)object2), unit);
            Intrinsics.checkExpressionValueIsNotNull((Object)duration2, (String)"Duration.of(amount.toLong(), unit)");
            object = duration2;
        }
        catch (Throwable error) {
            throw (Throwable)((Object)new TimeoutEnforcerException.InvalidConfiguration(durationSpec));
        }
        return object;
    }

    private ProjectPropertiesParser() {
    }

    static {
        ProjectPropertiesParser projectPropertiesParser;
        INSTANCE = projectPropertiesParser = new ProjectPropertiesParser();
        SPEC_SECONDS = SetsKt.setOf((Object[])new String[]{"SECONDS", "SECOND"});
        SPEC_MINUTES = SetsKt.setOf((Object[])new String[]{"MINUTES", "MINUTE"});
        SPEC_HOURS = SetsKt.setOf((Object[])new String[]{"HOURS", "HOUR"});
    }
}

