/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.bootstrap.encrypt;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.AutoConfigureAfter;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.cloud.bootstrap.encrypt.EncryptionBootstrapConfiguration;
import org.springframework.cloud.bootstrap.encrypt.KeyProperties;
import org.springframework.cloud.bootstrap.encrypt.KeySpecProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Conditional;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Primary;
import org.springframework.security.crypto.encrypt.TextEncryptor;
import org.springframework.security.rsa.crypto.KeyStoreKeyFactory;
import org.springframework.security.rsa.crypto.RsaSecretEncryptor;

@Configuration
@ConditionalOnClass(value={TextEncryptor.class})
@AutoConfigureAfter(value={EncryptionBootstrapConfiguration.class})
@EnableConfigurationProperties(value={KeySpecProperties.class})
@ConditionalOnProperty(prefix="key-spec", name={"enabled"}, matchIfMissing=true)
public class EncryptionBootstrapConfigurationAfter {

    @Configuration
    @Conditional(value={EncryptionBootstrapConfiguration.KeyCondition.class})
    @ConditionalOnMissingClass(value={"org.springframework.security.rsa.crypto.RsaSecretEncryptor"})
    protected static class VanillaEncryptionConfigurationCustom {
        @Autowired
        private KeyProperties key;
        @Autowired
        private KeySpecProperties keySpec;

        protected VanillaEncryptionConfigurationCustom() {
        }

        @Bean
        @Primary
        public TextEncryptor textEncryptor() {
            return this.keySpec.getTextEncryptor(this.key.getKey());
        }
    }

    @Configuration
    @Conditional(value={EncryptionBootstrapConfiguration.KeyCondition.class})
    @ConditionalOnClass(value={RsaSecretEncryptor.class})
    protected static class RsaEncryptionConfigurationCustom {
        @Autowired
        private KeyProperties key;
        @Autowired
        private KeySpecProperties keySpec;

        protected RsaEncryptionConfigurationCustom() {
        }

        @Bean
        @Primary
        public TextEncryptor textEncryptor() {
            KeyProperties.KeyStore keyStore = this.key.getKeyStore();
            if (keyStore.getLocation() != null && keyStore.getLocation().exists()) {
                return new RsaSecretEncryptor(new KeyStoreKeyFactory(keyStore.getLocation(), keyStore.getPassword().toCharArray()).getKeyPair(keyStore.getAlias(), keyStore.getSecret().toCharArray()), this.key.getRsa().getAlgorithm(), this.key.getRsa().getSalt(), this.key.getRsa().isStrong());
            }
            return this.keySpec.getTextEncryptor(this.key.getKey());
        }
    }
}

