/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.autoconfigure.web;

import io.undertow.Undertow;
import java.net.InetAddress;
import javax.servlet.Servlet;
import org.eclipse.jetty.server.Connector;
import org.eclipse.jetty.server.NetworkTrafficServerConnector;
import org.eclipse.jetty.server.Server;
import org.springframework.boot.autoconfigure.AutoConfigureAfter;
import org.springframework.boot.autoconfigure.AutoConfigureOrder;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.autoconfigure.condition.ConditionalOnWebApplication;
import org.springframework.boot.autoconfigure.condition.SearchStrategy;
import org.springframework.boot.autoconfigure.web.EmbeddedServletContainerAutoConfiguration;
import org.springframework.boot.context.embedded.ConfigurableEmbeddedServletContainer;
import org.springframework.boot.context.embedded.EmbeddedServletContainerCustomizer;
import org.springframework.boot.context.embedded.EmbeddedServletContainerFactory;
import org.springframework.boot.context.embedded.jetty.JettyEmbeddedServletContainerFactory;
import org.springframework.boot.context.embedded.jetty.JettyServerCustomizer;
import org.springframework.boot.context.embedded.tomcat.TomcatEmbeddedServletContainerFactory;
import org.springframework.boot.context.embedded.undertow.UndertowBuilderCustomizer;
import org.springframework.boot.context.embedded.undertow.UndertowEmbeddedServletContainerFactory;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@AutoConfigureOrder(value=-2147483648)
@Configuration
@ConditionalOnClass(value={Servlet.class})
@ConditionalOnWebApplication
@ConditionalOnProperty(prefix="server.http", name={"port"})
@ConfigurationProperties(value="server.http")
@AutoConfigureAfter(value={EmbeddedServletContainerAutoConfiguration.class})
public class EmbeddedServletContainerAutoConfigurationAfter {
    private int port = -1;
    private InetAddress address;

    @Bean
    @ConditionalOnBean(value={EmbeddedServletContainerFactory.class}, search=SearchStrategy.CURRENT)
    public EmbeddedServletContainerCustomizer containerCustomizer() {
        return new EmbeddedServletContainerCustomizer(){

            public void customize(ConfigurableEmbeddedServletContainer container) {
                if (container instanceof TomcatEmbeddedServletContainerFactory) {
                    org.apache.catalina.connector.Connector connector = new org.apache.catalina.connector.Connector("org.apache.coyote.http11.Http11NioProtocol");
                    connector.setPort(EmbeddedServletContainerAutoConfigurationAfter.this.port);
                    if (EmbeddedServletContainerAutoConfigurationAfter.this.getAddress() != null) {
                        connector.setDomain(EmbeddedServletContainerAutoConfigurationAfter.this.getAddress().getHostAddress());
                    }
                    ((TomcatEmbeddedServletContainerFactory)container).addAdditionalTomcatConnectors(new org.apache.catalina.connector.Connector[]{connector});
                }
                if (container instanceof JettyEmbeddedServletContainerFactory) {
                    ((JettyEmbeddedServletContainerFactory)container).addServerCustomizers(new JettyServerCustomizer[]{new JettyServerCustomizer(){

                        public void customize(Server server) {
                            NetworkTrafficServerConnector serverConnector = new NetworkTrafficServerConnector(server);
                            serverConnector.setPort(EmbeddedServletContainerAutoConfigurationAfter.this.port);
                            if (EmbeddedServletContainerAutoConfigurationAfter.this.getAddress() != null) {
                                serverConnector.setHost(EmbeddedServletContainerAutoConfigurationAfter.this.getAddress().getHostAddress());
                            }
                            server.addConnector((Connector)serverConnector);
                        }
                    }});
                }
                if (container instanceof UndertowEmbeddedServletContainerFactory) {
                    ((UndertowEmbeddedServletContainerFactory)container).addBuilderCustomizers(new UndertowBuilderCustomizer[]{new UndertowBuilderCustomizer(){

                        public void customize(Undertow.Builder builder) {
                            String host = "0.0.0.0";
                            if (EmbeddedServletContainerAutoConfigurationAfter.this.getAddress() != null) {
                                host = EmbeddedServletContainerAutoConfigurationAfter.this.getAddress().getHostAddress();
                            }
                            builder.addHttpListener(EmbeddedServletContainerAutoConfigurationAfter.this.port, host);
                        }
                    }});
                }
            }
        };
    }

    public InetAddress getAddress() {
        return this.address;
    }

    public void setAddress(InetAddress address) {
        this.address = address;
    }

    public int getPort() {
        return this.port;
    }

    public void setPort(int port) {
        this.port = port;
    }
}

