/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.autoconfigure.web;

import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.Method;
import java.text.SimpleDateFormat;
import java.util.Collections;
import java.util.Date;
import java.util.LinkedHashMap;
import java.util.Locale;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.boot.autoconfigure.web.DefaultErrorAttributes;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.context.MessageSource;
import org.springframework.context.i18n.LocaleContextHolder;
import org.springframework.core.annotation.AnnotationUtils;
import org.springframework.exception.AbstractException;
import org.springframework.http.HttpStatus;
import org.springframework.util.Assert;
import org.springframework.util.LinkedCaseInsensitiveMap;
import org.springframework.util.ReflectionUtils;
import org.springframework.util.StringUtils;
import org.springframework.util.SystemPropertyUtils;
import org.springframework.validation.BindingResult;
import org.springframework.validation.FieldError;
import org.springframework.web.bind.annotation.ResponseStatus;
import org.springframework.web.context.request.RequestAttributes;
import org.springframework.web.context.request.ServletRequestAttributes;
import org.springframework.web.servlet.DispatcherServlet;
import org.springframework.web.util.ContentCachingRequestWrapper;
import org.springframework.web.util.ContentCachingResponseWrapper;
import org.springframework.web.util.WebUtils;

@ConfigurationProperties(prefix="error")
public class DefaultErrorAttributesCustom
extends DefaultErrorAttributes {
    protected final Log logger = LogFactory.getLog(((Object)((Object)this)).getClass());
    public static final Pattern PATTERN = Pattern.compile("(password[^=:\"\\s]*)([=:\"\\s]*)(\\w*)", 42);
    public static final String LINE_SEPARATOR = SystemPropertyUtils.resolvePlaceholders((String)"${line.separator:\r\n}");
    private Map<String, Number> status = new LinkedCaseInsensitiveMap();
    public static final String DEFAULT_ERROR = "error";
    public static final String DEFAULT_ERROR_TIMESTAMP = "error_timestamp";
    public static final String DEFAULT_ERROR_MESSAGE = "error_message";
    public static final String DEFAULT_ERROR_DESCRIPTION = "error_description";
    public static final String DEFAULT_ERROR_TRACE = "error_trace";
    public static final String DEFAULT_ERROR_STATUS = "error_status";
    public static final String DEFAULT_ERROR_URI = "error_uri";
    public static final String DEFAULT_ERROR_THROWABLE = "error_throwable";
    public static final String DEFAULT_ERROR_EXCEPTION = "error_exception";
    public static final String DEFAULT_ERRORS = "errors";
    public static final String DEFAULT_ERRORS_COUNT = "errors_count";
    private String error = "error";
    private String error_timestamp = "error_timestamp";
    private String error_message = "error_message";
    private String error_description = "error_description";
    private String error_trace = "error_trace";
    private String error_status = "error_status";
    private String error_uri = "error_uri";
    private String error_throwable = "error_throwable";
    private String error_exception = "error_exception";
    private String errors = "errors";
    private String errors_count = "errors_count";
    private MessageSource messageSource;

    public DefaultErrorAttributesCustom(MessageSource messageSource) {
        Assert.notNull((Object)messageSource, (String)"'messageSource' must not be null");
        this.messageSource = messageSource;
    }

    public Map<String, Object> getErrorAttributes(RequestAttributes requestAttributes, boolean includeStackTrace) {
        Map errorAttributes = super.getErrorAttributes(requestAttributes, includeStackTrace);
        errorAttributes.put(this.error_timestamp, new Date());
        Throwable exception = this.getError(requestAttributes);
        int status = this.getStatus(requestAttributes);
        if (exception == null) {
            errorAttributes.put(this.error_description, this.messageSource.getMessage(String.valueOf(status), null, "", this.getLocale()));
        } else {
            String localizedMessage;
            ResponseStatus responseStatus;
            this.print(exception, requestAttributes, includeStackTrace);
            boolean abstractException = exception instanceof AbstractException;
            if (abstractException) {
                status = ((AbstractException)exception).getStatus();
            }
            if ((responseStatus = (ResponseStatus)AnnotationUtils.findAnnotation(exception.getClass(), ResponseStatus.class)) != null) {
                status = responseStatus.value().value();
            }
            String exceptionCode = exception.getClass().getName();
            status = this.status.getOrDefault(exceptionCode, status).intValue();
            if (requestAttributes instanceof ServletRequestAttributes) {
                ((ServletRequestAttributes)requestAttributes).getRequest().setAttribute("javax.servlet.error.status_code", (Object)status);
            }
            errorAttributes.put(this.error_exception, exception.getClass().getName());
            errorAttributes.put(this.error_status, status);
            errorAttributes.put(this.error_message, exception.getMessage());
            String code = this.getCode(exception);
            errorAttributes.put(this.error, this.getCode(exception));
            errorAttributes.put(this.error_uri, this.getPath(requestAttributes));
            if (includeStackTrace) {
                errorAttributes.put(this.error_trace, this.getStackTrace(exception));
            }
            if (StringUtils.hasText((String)(localizedMessage = exception.getLocalizedMessage())) && localizedMessage.contains("; nested exception is ")) {
                localizedMessage = localizedMessage.substring(0, localizedMessage.indexOf("; nested exception is "));
            }
            Object[] args = abstractException ? ((AbstractException)exception).getArgs() : null;
            BindingResult result = this.extractBindingResult(exception);
            if (result != null) {
                errorAttributes.put(this.errors, result);
                errorAttributes.put(this.errors_count, result.getErrorCount());
                LinkedHashMap<String, String> errors = new LinkedHashMap<String, String>();
                for (FieldError fieldError : result.getFieldErrors()) {
                    String key = fieldError.getObjectName() + '.' + fieldError.getField();
                    errors.put(key, this.messageSource.getMessage(key, fieldError.getArguments(), fieldError.getDefaultMessage(), this.getLocale()));
                }
                errorAttributes.put(this.errors, errors);
            }
            errorAttributes.put(this.error_description, this.messageSource.getMessage(code, args, localizedMessage, this.getLocale()));
        }
        return errorAttributes;
    }

    protected Integer getStatus(RequestAttributes requestAttributes) {
        Integer statusCode;
        if (requestAttributes instanceof ServletRequestAttributes && (statusCode = (Integer)((ServletRequestAttributes)requestAttributes).getRequest().getAttribute("javax.servlet.error.status_code")) != null) {
            return statusCode;
        }
        return HttpStatus.INTERNAL_SERVER_ERROR.value();
    }

    protected void print(Throwable exception, RequestAttributes requestAttributes, boolean includeStackTrace) {
        if (requestAttributes instanceof ServletRequestAttributes) {
            String message = this.getMessage(exception, ((ServletRequestAttributes)requestAttributes).getRequest(), includeStackTrace);
            if (this.logger.isTraceEnabled()) {
                this.logger.trace((Object)message, exception);
            } else if (this.logger.isErrorEnabled()) {
                this.logger.error((Object)message);
            }
        }
    }

    private String getMessage(Throwable exception, HttpServletRequest request, boolean includeStackTrace) {
        byte[] buf;
        StringBuilder stringBuilder = new StringBuilder(LINE_SEPARATOR);
        stringBuilder.append("TIME: ");
        stringBuilder.append(new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSS'Z'Z", Locale.getDefault()).format(new Date()));
        stringBuilder.append(LINE_SEPARATOR);
        stringBuilder.append(LINE_SEPARATOR);
        stringBuilder.append("SERVER: ");
        stringBuilder.append(request.getScheme());
        stringBuilder.append("://");
        stringBuilder.append(request.getServerName());
        stringBuilder.append(':');
        stringBuilder.append(request.getServerPort());
        String requestURI = DefaultErrorAttributesCustom.getRequestUri(request);
        stringBuilder.append(requestURI);
        String queryString = DefaultErrorAttributesCustom.getQueryString(request);
        stringBuilder.append(queryString);
        stringBuilder.append(LINE_SEPARATOR);
        stringBuilder.append(LINE_SEPARATOR);
        stringBuilder.append("REMOTE: ");
        stringBuilder.append(request.getRemoteAddr());
        stringBuilder.append(':');
        stringBuilder.append(request.getRemotePort());
        stringBuilder.append(LINE_SEPARATOR);
        stringBuilder.append(LINE_SEPARATOR);
        stringBuilder.append("EXCEPTION: ");
        stringBuilder.append(exception.getMessage());
        stringBuilder.append(LINE_SEPARATOR);
        stringBuilder.append(LINE_SEPARATOR);
        if (includeStackTrace) {
            stringBuilder.append("TRACE: ");
            StringWriter stackTrace = new StringWriter();
            exception.printStackTrace(new PrintWriter(stackTrace));
            stackTrace.flush();
            stringBuilder.append(stackTrace);
            stringBuilder.append(LINE_SEPARATOR);
            stringBuilder.append(LINE_SEPARATOR);
        }
        stringBuilder.append("RAW: ");
        stringBuilder.append(LINE_SEPARATOR);
        stringBuilder.append(request.getMethod());
        stringBuilder.append(' ');
        stringBuilder.append(request.getScheme());
        stringBuilder.append("://");
        stringBuilder.append(request.getServerName());
        stringBuilder.append(':');
        stringBuilder.append(request.getServerPort());
        stringBuilder.append(requestURI);
        stringBuilder.append(queryString);
        stringBuilder.append(' ');
        stringBuilder.append(request.getProtocol());
        stringBuilder.append(LINE_SEPARATOR);
        for (String headerName : Collections.list(request.getHeaderNames())) {
            stringBuilder.append(headerName);
            stringBuilder.append(": ");
            if ("Cookie".equalsIgnoreCase(headerName)) {
                stringBuilder.append(StringUtils.collectionToDelimitedString(Collections.list(request.getHeaders(headerName)), (String)"; "));
            } else {
                stringBuilder.append(StringUtils.collectionToCommaDelimitedString(Collections.list(request.getHeaders(headerName))));
            }
            stringBuilder.append(LINE_SEPARATOR);
        }
        stringBuilder.append(LINE_SEPARATOR);
        StringBuilder parameter = new StringBuilder();
        ContentCachingRequestWrapper contentCachingRequestWrapper = (ContentCachingRequestWrapper)WebUtils.getNativeRequest((ServletRequest)request, ContentCachingRequestWrapper.class);
        if (contentCachingRequestWrapper == null) {
            for (String parameterName : Collections.list(request.getParameterNames())) {
                if (StringUtils.hasText((CharSequence)parameter)) {
                    parameter.append('&');
                }
                parameter.append(parameterName);
                parameter.append('=');
                parameter.append(StringUtils.arrayToCommaDelimitedString((Object[])request.getParameterValues(parameterName)));
            }
        } else {
            byte[] buf2 = contentCachingRequestWrapper.getContentAsByteArray();
            if (buf2.length > 0) {
                try {
                    String body = new String(buf2, 0, buf2.length, contentCachingRequestWrapper.getCharacterEncoding());
                    Matcher matcher = PATTERN.matcher(body);
                    while (matcher.find()) {
                        body = body.replaceFirst(matcher.group(), matcher.group(1) + matcher.group(2) + "<masked>");
                    }
                    stringBuilder.append(body);
                }
                catch (UnsupportedEncodingException body) {
                    // empty catch block
                }
            }
        }
        stringBuilder.append(new String(parameter).replaceAll("password=[^&]*", "password=<masked>"));
        ContentCachingResponseWrapper contentCachingResponseWrapper = (ContentCachingResponseWrapper)WebUtils.getNativeRequest((ServletRequest)request, ContentCachingResponseWrapper.class);
        if (contentCachingResponseWrapper != null && (buf = contentCachingResponseWrapper.getContentAsByteArray()).length > 0) {
            try {
                stringBuilder.append(new String(buf, 0, buf.length, contentCachingResponseWrapper.getCharacterEncoding()));
                contentCachingResponseWrapper.copyBodyToResponse();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return new String(stringBuilder);
    }

    private Locale getLocale() {
        Locale locale = LocaleContextHolder.getLocale();
        if (locale == null) {
            locale = Locale.getDefault();
        }
        return locale;
    }

    public Throwable getError(RequestAttributes requestAttributes) {
        Throwable exception = super.getError(requestAttributes);
        if (exception == null) {
            exception = (Throwable)this.getAttribute(requestAttributes, DispatcherServlet.EXCEPTION_ATTRIBUTE);
        }
        if (exception == null) {
            exception = (Throwable)this.getAttribute(requestAttributes, "SPRING_SECURITY_403_EXCEPTION");
        }
        if (exception == null) {
            exception = (Throwable)this.getSessionAttribute(requestAttributes, "SPRING_SECURITY_403_EXCEPTION");
        }
        if (exception == null) {
            exception = (Throwable)this.getAttribute(requestAttributes, "SPRING_SECURITY_LAST_EXCEPTION");
        }
        if (exception == null) {
            exception = (Throwable)this.getSessionAttribute(requestAttributes, "SPRING_SECURITY_LAST_EXCEPTION");
        }
        while (exception instanceof ServletException && exception.getCause() != null) {
            exception = ((ServletException)exception).getCause();
        }
        return exception;
    }

    private <T> T getAttribute(RequestAttributes requestAttributes, String name) {
        return (T)requestAttributes.getAttribute(name, 0);
    }

    private <T> T getSessionAttribute(RequestAttributes requestAttributes, String name) {
        return (T)requestAttributes.getAttribute(name, 1);
    }

    private String getCode(Throwable exception) {
        Object invokeMethod;
        Method method = ReflectionUtils.findMethod(exception.getClass(), (String)"getCode");
        if (method != null && (invokeMethod = ReflectionUtils.invokeMethod((Method)method, (Object)exception)) instanceof String) {
            return (String)invokeMethod;
        }
        return exception.getClass().getName();
    }

    private BindingResult extractBindingResult(Throwable exception) {
        Object invokeMethod;
        if (exception instanceof BindingResult) {
            return (BindingResult)exception;
        }
        Method method = ReflectionUtils.findMethod(exception.getClass(), (String)"getBindingResult");
        if (method != null && (invokeMethod = ReflectionUtils.invokeMethod((Method)method, (Object)exception)) instanceof BindingResult) {
            return (BindingResult)invokeMethod;
        }
        return null;
    }

    private String getStackTrace(Throwable exception) {
        StringWriter stackTrace = new StringWriter();
        exception.printStackTrace(new PrintWriter(stackTrace));
        stackTrace.flush();
        return stackTrace.toString();
    }

    private String getPath(RequestAttributes requestAttributes) {
        String path = (String)this.getAttribute(requestAttributes, "javax.servlet.error.request_uri");
        if (path == null) {
            path = (String)this.getAttribute(requestAttributes, "javax.servlet.forward.request_uri");
        }
        if (path == null && requestAttributes instanceof ServletRequestAttributes) {
            path = ((ServletRequestAttributes)requestAttributes).getRequest().getRequestURI();
        }
        return path;
    }

    public static String getRequestUri(HttpServletRequest request) {
        Object requestURI = request.getAttribute("javax.servlet.error.request_uri");
        if (requestURI == null) {
            requestURI = request.getAttribute("javax.servlet.forward.request_uri");
        }
        if (requestURI == null) {
            requestURI = request.getAttribute("javax.servlet.include.request_uri");
        }
        if (requestURI == null) {
            requestURI = request.getRequestURI();
        }
        if (requestURI == null) {
            return "";
        }
        return String.valueOf(requestURI).replaceAll("\\r\\n|\\r|\\n", " ");
    }

    public static String getQueryString(HttpServletRequest request) {
        Object queryString = request.getAttribute("javax.servlet.forward.query_string");
        if (queryString == null) {
            queryString = request.getAttribute("javax.servlet.include.query_string");
        }
        if (queryString == null) {
            queryString = request.getQueryString();
        }
        if (queryString == null) {
            return "";
        }
        return '?' + String.valueOf(queryString).replaceAll("\\r\\n|\\r|\\n", " ");
    }

    public Map<String, Number> getStatus() {
        return this.status;
    }

    public void setStatus(Map<String, Number> status) {
        this.status = status;
    }
}

