/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.autoconfigure.jdbc.metadata;

import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import javax.sql.DataSource;
import org.springframework.beans.BeansException;
import org.springframework.boot.autoconfigure.jdbc.metadata.DataSourcePoolMetadata;
import org.springframework.boot.autoconfigure.jdbc.metadata.DataSourcePoolMetadataProvider;
import org.springframework.boot.autoconfigure.jdbc.metadata.DataSourcePoolMetadataProviders;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.jdbc.datasource.LazyConnectionDataSourceProxy;

public class DecoratorDataSourcePoolMetadataProvider
implements DataSourcePoolMetadataProvider,
ApplicationContextAware {
    private DataSourcePoolMetadataProvider dataSourcePoolMetadataProvider;

    public DataSourcePoolMetadata getDataSourcePoolMetadata(DataSource dataSource) {
        DataSource targetDataSource = dataSource;
        if (targetDataSource instanceof LazyConnectionDataSourceProxy) {
            targetDataSource = ((LazyConnectionDataSourceProxy)targetDataSource).getTargetDataSource();
        }
        try {
            while (targetDataSource.isWrapperFor(DataSource.class) && !targetDataSource.equals(dataSource = targetDataSource.unwrap(DataSource.class))) {
                targetDataSource = dataSource;
            }
        }
        catch (SQLException e) {
            throw new IllegalStateException(e);
        }
        return this.dataSourcePoolMetadataProvider.getDataSourcePoolMetadata(targetDataSource);
    }

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        Collection delegates = applicationContext.getBeansOfType(DataSourcePoolMetadataProvider.class).values();
        ArrayList<DataSourcePoolMetadataProvider> dataSourcePoolMetadataProviders = new ArrayList<DataSourcePoolMetadataProvider>();
        for (DataSourcePoolMetadataProvider delegate : delegates) {
            if (delegate instanceof DecoratorDataSourcePoolMetadataProvider) continue;
            dataSourcePoolMetadataProviders.add(delegate);
        }
        this.dataSourcePoolMetadataProvider = new DataSourcePoolMetadataProviders(dataSourcePoolMetadataProviders);
    }
}

