/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.autoconfigure.jdbc;

import com.p6spy.engine.spy.P6DataSource;
import javax.sql.DataSource;
import net.ttddyy.dsproxy.support.ProxyDataSource;
import org.springframework.boot.autoconfigure.AutoConfigureAfter;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.autoconfigure.jdbc.DataSourceAutoConfiguration;
import org.springframework.boot.autoconfigure.jdbc.DataSourceDecorator;
import org.springframework.boot.autoconfigure.jdbc.DataSourceDecoratorPostProcessor;
import org.springframework.boot.autoconfigure.jdbc.DataSourceDecoratorProperties;
import org.springframework.boot.autoconfigure.jdbc.metadata.DataSourcePoolMetadataProvider;
import org.springframework.boot.autoconfigure.jdbc.metadata.DecoratorDataSourcePoolMetadataProvider;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.ApplicationContext;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.jdbc.datasource.LazyConnectionDataSourceProxy;

@Configuration
@EnableConfigurationProperties(value={DataSourceDecoratorProperties.class})
@ConditionalOnProperty(prefix="spring.datasource.decorator", name={"enabled"}, matchIfMissing=true)
@ConditionalOnBean(value={DataSource.class})
@AutoConfigureAfter(value={DataSourceAutoConfiguration.class})
public class DataSourceDecoratorAutoConfiguration {
    @Bean
    public DataSourceDecoratorPostProcessor dataSourceDecoratorBeanPostProcessor(DataSourceDecoratorProperties properties, ApplicationContext applicationContext) {
        return new DataSourceDecoratorPostProcessor(properties, applicationContext);
    }

    @Bean
    public DataSourcePoolMetadataProvider decoratorDataSourcePoolMetadataProvider() {
        return new DecoratorDataSourcePoolMetadataProvider();
    }

    @Bean
    public DataSourceDecorator lazyConnectionDataSourceProxyDecorator() {
        return new DataSourceDecorator(){

            @Override
            public DataSource decorate(DataSource dataSource) {
                return new LazyConnectionDataSourceProxy(dataSource);
            }

            public int getOrder() {
                return Integer.MAX_VALUE;
            }
        };
    }

    @Configuration
    @ConditionalOnClass(value={ProxyDataSource.class})
    protected static class ProxyDataSourceDecoratorConfiguration {
        protected ProxyDataSourceDecoratorConfiguration() {
        }

        @Bean
        public DataSourceDecorator proxyDataSourceDecorator() {
            return new DataSourceDecorator(){

                @Override
                public DataSource decorate(DataSource dataSource) {
                    return new ProxyDataSource(dataSource);
                }

                public int getOrder() {
                    return 2147483627;
                }
            };
        }
    }

    @Configuration
    @ConditionalOnClass(value={P6DataSource.class})
    protected static class P6SpyDataSourceDecoratorConfiguration {
        protected P6SpyDataSourceDecoratorConfiguration() {
        }

        @Bean
        public DataSourceDecorator p6SpyDataSourceDecorator() {
            return new DataSourceDecorator(){

                @Override
                public DataSource decorate(DataSource dataSource) {
                    return new P6DataSource(dataSource);
                }

                public int getOrder() {
                    return 0x7FFFFFF5;
                }
            };
        }
    }
}

