/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.autoconfigure.context;

import org.springframework.boot.autoconfigure.AutoConfigureBefore;
import org.springframework.boot.autoconfigure.AutoConfigureOrder;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.SearchStrategy;
import org.springframework.boot.autoconfigure.context.MessageSourceAutoConfiguration;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.MessageSource;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.support.ReloadableResourceBundleMessageSourceCustom;
import org.springframework.context.support.ResourceBundleMessageSource;
import org.springframework.util.ClassUtils;

@Configuration
@ConditionalOnMissingBean(value={MessageSource.class}, search=SearchStrategy.CURRENT)
@AutoConfigureOrder(value=-2147483648)
@EnableConfigurationProperties
@ConditionalOnClass(value={MessageSource.class})
@AutoConfigureBefore(value={MessageSourceAutoConfiguration.class})
public class MessageSourceAutoConfigurationBefore {
    @Bean
    @ConfigurationProperties(value="spring.messagesource")
    public ReloadableResourceBundleMessageSourceCustom messageSource() {
        ReloadableResourceBundleMessageSourceCustom reloadableResourceBundleMessageSource = new ReloadableResourceBundleMessageSourceCustom();
        ResourceBundleMessageSource parentMessageSource = new ResourceBundleMessageSource();
        parentMessageSource.setBasename(ClassUtils.getPackageName(MessageSource.class) + ".messages");
        reloadableResourceBundleMessageSource.setParentMessageSource((MessageSource)parentMessageSource);
        reloadableResourceBundleMessageSource.setUseCodeAsDefaultMessage(true);
        return reloadableResourceBundleMessageSource;
    }
}

