/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.actuate.health;

import java.io.File;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.core.io.FileSystemResource;
import org.springframework.core.io.Resource;

@ConfigurationProperties(prefix="management.health.mount")
public class MountHealthIndicatorProperties {
    private static final long EXECUTE = 1L;
    private static final long WRITE = 2L;
    private static final long READ = 4L;
    private static final long FILE = 1L;
    private static final long DIRECTORY = 2L;
    private static final long ABSOLUTE = 4L;
    private static final long HIDDEN = 8L;
    private Resource resource = new FileSystemResource(new File("."));
    private long access = 7L;
    private long type = 2L;

    public Resource getResource() {
        return this.resource;
    }

    public void setResource(Resource resource) {
        this.resource = resource;
    }

    public boolean isRead() {
        return (this.access & 4L) == 4L;
    }

    public void setRead(boolean read) {
        this.access = read ? this.access | 4L : this.access & 0xFFFFFFFFFFFFFFFBL;
    }

    public boolean isExecute() {
        return (this.access & 1L) == 1L;
    }

    public void setExecute(boolean execute) {
        this.access = execute ? this.access | 1L : this.access & 0xFFFFFFFFFFFFFFFEL;
    }

    public boolean isWrite() {
        return (this.access & 2L) == 2L;
    }

    public void setWrite(boolean write) {
        this.access = write ? this.access | 2L : this.access & 0xFFFFFFFFFFFFFFFDL;
    }

    public long getAccess() {
        return this.access;
    }

    public void setAccess(long access) {
        this.access = access;
    }

    public boolean isFile() {
        return (this.type & 1L) == 1L;
    }

    public void setFile(boolean file) {
        this.type = file ? this.type | 1L : this.type & 0xFFFFFFFFFFFFFFFEL;
    }

    public boolean isDirectory() {
        return (this.type & 2L) == 2L;
    }

    public void setDirectory(boolean directory) {
        this.type = directory ? this.type | 2L : this.type & 0xFFFFFFFFFFFFFFFDL;
    }

    public boolean isAbsolute() {
        return (this.type & 4L) == 4L;
    }

    public void setAbsolute(boolean absolute) {
        this.type = absolute ? this.type | 4L : this.type & 0xFFFFFFFFFFFFFFFBL;
    }

    public boolean isHidden() {
        return (this.type & 8L) == 8L;
    }

    public void setHidden(boolean hidden) {
        this.type = hidden ? this.type | 8L : this.type & 0xFFFFFFFFFFFFFFF7L;
    }

    public long getType() {
        return this.type;
    }

    public void setType(long type) {
        this.type = type;
    }
}

