/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.actuate.health;

import java.io.File;
import java.lang.constant.Constable;
import java.util.LinkedHashMap;
import java.util.UUID;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.boot.actuate.health.AbstractHealthIndicator;
import org.springframework.boot.actuate.health.Health;
import org.springframework.boot.actuate.health.MountHealthIndicatorProperties;
import org.springframework.core.io.Resource;
import org.springframework.util.Assert;

public class MountHealthIndicator
extends AbstractHealthIndicator {
    protected final Log logger = LogFactory.getLog(((Object)((Object)this)).getClass());
    private final MountHealthIndicatorProperties properties;

    public MountHealthIndicator(MountHealthIndicatorProperties properties) {
        this.properties = properties;
    }

    protected void doHealthCheck(Health.Builder builder) throws Exception {
        Resource resource = this.properties.getResource();
        Assert.notNull((Object)resource, (String)"'resource' must not be null ('management.health.mount.resource=file:/data'");
        Assert.isTrue((boolean)resource.exists(), (String)("'resource' not exist from: " + resource));
        File file = resource.getFile().getCanonicalFile();
        builder.withDetail("file", (Object)file);
        LinkedHashMap<String, Constable> access = new LinkedHashMap<String, Constable>();
        access.put("access", Long.valueOf(this.properties.getAccess()));
        access.put("execute", Boolean.valueOf(this.properties.isExecute()));
        access.put("read", Boolean.valueOf(this.properties.isRead()));
        access.put("write", Boolean.valueOf(this.properties.isWrite()));
        builder.withDetail("access", access);
        LinkedHashMap<String, Constable> type = new LinkedHashMap<String, Constable>();
        type.put("type", Long.valueOf(this.properties.getType()));
        type.put("file", Boolean.valueOf(this.properties.isFile()));
        type.put("directory", Boolean.valueOf(this.properties.isDirectory()));
        type.put("absolute", Boolean.valueOf(this.properties.isAbsolute()));
        type.put("hidden", Boolean.valueOf(this.properties.isHidden()));
        builder.withDetail("type", type);
        if (this.properties.isFile()) {
            Assert.isTrue((boolean)file.isFile(), (String)"file not isFile");
        }
        if (this.properties.isDirectory()) {
            Assert.isTrue((boolean)file.isDirectory(), (String)"file not isDirectory");
        }
        if (this.properties.isAbsolute()) {
            Assert.isTrue((boolean)file.isAbsolute(), (String)"file not isAbsolute");
        }
        if (this.properties.isHidden()) {
            Assert.isTrue((boolean)file.isHidden(), (String)"file not isHidden");
        }
        if (this.properties.isExecute()) {
            Assert.isTrue((boolean)file.canExecute(), (String)"file not canExecute");
        }
        if (this.properties.isWrite()) {
            Assert.isTrue((boolean)file.canWrite(), (String)"file not canWrite");
            if (this.properties.isDirectory()) {
                Assert.isTrue((boolean)File.createTempFile(UUID.randomUUID().toString() + '-', null, file).delete(), (String)("file delete fail from: " + file));
            }
        }
        if (this.properties.isRead()) {
            Assert.isTrue((boolean)file.canRead(), (String)"file not canRead");
        }
        builder.up();
    }
}

