package org.springframework.boot.web.filter;

import org.springframework.core.Ordered;
import org.springframework.web.filter.ForwardedHeaderFilter;

/**
 * <pre>
 * Forwarded: host=server:port; proto=scheme
 * X-Forwarded-Host: host
 * X-Forwarded-Port: port
 * X-Forwarded-Proto: scheme
 * X-Forwarded-Prefix: /
 * 
 * X-Real-IP: remote
 * X-Forwarded-For: remote,remote
 * X-Forwarded-Server: server
 * </pre>
 * 
 * @see org.springframework.http.server.ServletServerHttpRequest#getURI()
 */
public class OrderedForwardedHeaderFilter extends ForwardedHeaderFilter implements Ordered {
  private int order = Ordered.HIGHEST_PRECEDENCE + 250;

  @Override
  public int getOrder() {
    return order;
  }

  public void setOrder(int order) {
    this.order = order;
  }
}
