package org.springframework.boot.autoconfigure.web;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

import org.springframework.context.ResourceLoaderAware;
import org.springframework.core.io.Resource;
import org.springframework.core.io.ResourceLoader;
import org.springframework.http.HttpEntity;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Controller;
import org.springframework.util.MediaTypeUtils;
import org.springframework.web.bind.annotation.RequestMapping;

@Controller
@RequestMapping("${apple-app-site-association.path:/apple-app-site-association}")
public class AppleAppSiteAssociationController implements ResourceLoaderAware {
  private final ResourceProperties resourceProperties;
  private ResourceLoader resourceLoader;

  public AppleAppSiteAssociationController(ResourceProperties resourceProperties) {
    this.resourceProperties = resourceProperties;
  }

  @Override
  public void setResourceLoader(ResourceLoader resourceLoader) {
    this.resourceLoader = resourceLoader;
  }

  @RequestMapping
  public HttpEntity<?> appleAppSiteAssociation() {
    List<String> list = new ArrayList<String>();
    for (String staticLocation : resourceProperties.getStaticLocations()) {
      if (!staticLocation.endsWith("/")) {
        staticLocation = staticLocation + "/";
      }
      list.add(staticLocation + "apple-app-site-association.json");
      list.add(staticLocation + "apple-app-site-association.xml");
      list.add(staticLocation + "apple-app-site-association.html");
    }

    Resource resource = getResource(list.toArray(new String[list.size()]));
    if (resource == null) {
      return ResponseEntity.ok(Collections.emptyMap());
    }
    MediaType mediaType = MediaTypeUtils.parseMediaType(resource);
    return ResponseEntity.ok().contentType(mediaType).body(resource);
  }

  public Resource getResource(String... locations) {
    for (String location : locations) {
      Resource resource = this.resourceLoader.getResource(location);
      try {
        if (resource.exists()) {
          resource.getURL();
          return resource;
        }
      }
      catch (Exception ex) {
        // Ignore
      }
    }
    return null;
  }
}
