package org.springframework.boot.autoconfigure.validation;

import javax.validation.executable.ExecutableValidator;

import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.boot.autoconfigure.AutoConfigureBefore;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnResource;
import org.springframework.boot.validation.MessageInterpolatorFactory;
import org.springframework.context.MessageSource;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Role;
import org.springframework.context.support.StaticMessageSource;
import org.springframework.validation.beanvalidation.LocalValidatorFactoryBean;

@Configuration
@ConditionalOnClass(ExecutableValidator.class)
@ConditionalOnResource(resources = "classpath:META-INF/services/javax.validation.spi.ValidationProvider")
@AutoConfigureBefore(ValidationAutoConfiguration.class)
public class ValidationAutoConfigurationBefore {
  @Bean
  @Role(BeanDefinition.ROLE_INFRASTRUCTURE)
  public static LocalValidatorFactoryBean defaultValidator(MessageSource messageSource) {
    StaticMessageSource staticMessageSource = new StaticMessageSource();
    staticMessageSource.setParentMessageSource(messageSource);

    LocalValidatorFactoryBean factoryBean = new LocalValidatorFactoryBean();
    factoryBean.setMessageInterpolator(new MessageInterpolatorFactory().getObject());
    factoryBean.setValidationMessageSource(staticMessageSource);
    return factoryBean;
  }
}
