package org.springframework.boot.autoconfigure.scheduling;

import java.util.concurrent.Executor;

import org.springframework.aop.interceptor.AsyncUncaughtExceptionHandler;
import org.springframework.aop.interceptor.SimpleAsyncUncaughtExceptionHandler;
import org.springframework.boot.autoconfigure.AutoConfigureAfter;
import org.springframework.boot.autoconfigure.AutoConfigureBefore;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.scheduling.Trigger;
import org.springframework.scheduling.annotation.AsyncConfigurer;
import org.springframework.scheduling.concurrent.ThreadPoolTaskScheduler;

@ConditionalOnClass(Trigger.class)
@AutoConfigureBefore(SchedulingAutoConfigurationAfter.class)
@AutoConfigureAfter(SchedulingAutoConfigurationBefore.class)
@Configuration
@ConditionalOnProperty(prefix = "spring.scheduling", name = "auto", havingValue = "true", matchIfMissing = true)
public class SchedulingAutoConfiguration {
  @Configuration
  protected static class AsyncConfiguration implements AsyncConfigurer {
    /**
     * @see ThreadPoolTaskScheduler#setThreadNamePrefix(String)
     * @see ThreadPoolTaskScheduler#setRemoveOnCancelPolicy(boolean)
     */
    @Bean(name = "asyncTaskExecutor", destroyMethod = "shutdown")
    @ConfigurationProperties("executor")
    @Override
    public Executor getAsyncExecutor() {
      ThreadPoolTaskScheduler threadPoolTaskScheduler = new ThreadPoolTaskScheduler();
      threadPoolTaskScheduler.setPoolSize(Runtime.getRuntime().availableProcessors());
      return threadPoolTaskScheduler;
    }

    @Override
    public AsyncUncaughtExceptionHandler getAsyncUncaughtExceptionHandler() {
      return new SimpleAsyncUncaughtExceptionHandler();
    }
  }
}
