package org.springframework.boot.autoconfigure.context;

import org.springframework.boot.autoconfigure.AutoConfigureBefore;
import org.springframework.boot.autoconfigure.AutoConfigureOrder;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.SearchStrategy;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.MessageSource;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.support.ReloadableResourceBundleMessageSourceCustom;
import org.springframework.context.support.ResourceBundleMessageSource;
import org.springframework.core.Ordered;
import org.springframework.util.ClassUtils;

@Configuration
@ConditionalOnMissingBean(value = MessageSource.class, search = SearchStrategy.CURRENT)
@AutoConfigureOrder(Ordered.HIGHEST_PRECEDENCE)
@EnableConfigurationProperties
@ConditionalOnClass(MessageSource.class)
@AutoConfigureBefore(MessageSourceAutoConfiguration.class)
public class MessageSourceAutoConfigurationBefore {
  @Bean
  @ConfigurationProperties("spring.messagesource")
  public ReloadableResourceBundleMessageSourceCustom messageSource() {
    ReloadableResourceBundleMessageSourceCustom reloadableResourceBundleMessageSource = new ReloadableResourceBundleMessageSourceCustom();
    ResourceBundleMessageSource parentMessageSource = new ResourceBundleMessageSource();
    parentMessageSource.setBasename(ClassUtils.getPackageName(MessageSource.class) + ".messages");
    reloadableResourceBundleMessageSource.setParentMessageSource(parentMessageSource);
    // reloadableResourceBundleMessageSource.setParentMessageSource(new
    // ResourceBundleMessageSourceCustom(ClassUtils.getPackageName(Constants.class)));
    reloadableResourceBundleMessageSource.setUseCodeAsDefaultMessage(true);
    // Resource resource = applicationProperties.getMessage();
    // if (resource != null && resource.exists()) {
    // try {
    // File location = resource.getFile();
    // if (location.isDirectory()) {
    // for (String basenames : MessageUtil.getBasenames(location)) {
    // reloadableResourceBundleMessageSource.addBasenames(basenames);
    // }
    // }
    // }
    // catch (IOException e) {
    // }
    // }
    return reloadableResourceBundleMessageSource;
  }
}
