package org.springframework.boot.actuate.autoconfigure;

import org.springframework.boot.actuate.info.InfoContributor;
import org.springframework.boot.actuate.info.LocaleInfoContributor;
import org.springframework.boot.actuate.info.RequestInfoContributor;
import org.springframework.boot.actuate.info.ResourceInfoContributor;
import org.springframework.boot.autoconfigure.AutoConfigureAfter;
import org.springframework.boot.autoconfigure.AutoConfigureBefore;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.annotation.Order;

@Configuration
@ConditionalOnClass(InfoContributor.class)
@AutoConfigureAfter(InfoContributorAutoConfiguration.class)
@AutoConfigureBefore(EndpointAutoConfiguration.class)
public class InfoContributorAutoConfigurationAfter {
  @Bean
  @ConditionalOnEnabledInfoContributor("request")
  @Order(InfoContributorAutoConfiguration.DEFAULT_ORDER)
  public RequestInfoContributor requestInfoContributor() {
    return new RequestInfoContributor();
  }

  @Bean
  @ConditionalOnEnabledInfoContributor("resource")
  @Order(InfoContributorAutoConfiguration.DEFAULT_ORDER)
  public ResourceInfoContributor resourceInfoContributor() {
    return new ResourceInfoContributor();
  }

  @Bean
  @ConditionalOnEnabledInfoContributor("locale")
  @Order(InfoContributorAutoConfiguration.DEFAULT_ORDER)
  public LocaleInfoContributor localeInfoContributor() {
    return new LocaleInfoContributor();
  }
}
