package org.springframework.boot;

/**
 * @see org.springframework.core.SpringVersion
 */
public class Constants {
  public static class Environment {
    public static final String DEVELOPMENT = "development";
    public static final String PRODUCTION = "production";
  }

  public static class Page {
    public static final String CONTENT = "content";
  }

  public static class Authority {
    public static final String SYSTEM = "SYSTEM";
  }

  public static String getVersion() {
    Package pkg = Constants.class.getPackage();
    return pkg == null ? null : pkg.getImplementationVersion();
  }
}
