/*
 * Decompiled with CFR 0.152.
 */
package io.kubernetes.client.util;

import io.kubernetes.client.ApiClient;
import io.kubernetes.client.util.FilePersister;
import io.kubernetes.client.util.KubeConfig;
import io.kubernetes.client.util.credentials.AccessTokenAuthentication;
import io.kubernetes.client.util.credentials.Authentication;
import io.kubernetes.client.util.credentials.KubeconfigAuthentication;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.nio.file.Paths;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ClientBuilder {
    private static final Logger log = LoggerFactory.getLogger(ClientBuilder.class);
    private String basePath = "http://localhost:8080";
    private byte[] caCertBytes = null;
    private boolean verifyingSsl = true;
    private Authentication authentication;

    public static ApiClient defaultClient() throws IOException {
        return ClientBuilder.standard().build();
    }

    public static ClientBuilder standard() throws IOException {
        return ClientBuilder.standard(true);
    }

    public static ClientBuilder standard(boolean persistConfig) throws IOException {
        File kubeConfig = ClientBuilder.findConfigFromEnv();
        if (kubeConfig != null) {
            try (FileReader kubeConfigReader = new FileReader(kubeConfig);){
                KubeConfig kc = KubeConfig.loadKubeConfig(kubeConfigReader);
                if (persistConfig) {
                    kc.setPersistConfig(new FilePersister(kubeConfig));
                }
                ClientBuilder clientBuilder = ClientBuilder.kubeconfig(kc);
                return clientBuilder;
            }
        }
        File config = ClientBuilder.findConfigInHomeDir();
        if (config != null) {
            try (FileReader configReader = new FileReader(config);){
                KubeConfig kc = KubeConfig.loadKubeConfig(configReader);
                if (persistConfig) {
                    kc.setPersistConfig(new FilePersister(config));
                }
                ClientBuilder clientBuilder = ClientBuilder.kubeconfig(kc);
                return clientBuilder;
            }
        }
        File clusterCa = new File("/var/run/secrets/kubernetes.io/serviceaccount/ca.crt");
        if (clusterCa.exists()) {
            return ClientBuilder.cluster();
        }
        return new ClientBuilder();
    }

    private static File findConfigFromEnv() {
        String kubeConfigPath = System.getenv("KUBECONFIG");
        if (kubeConfigPath == null) {
            return null;
        }
        File kubeConfig = new File(kubeConfigPath);
        if (kubeConfig.exists()) {
            return kubeConfig;
        }
        log.debug("Could not find file specified in $KUBECONFIG");
        return null;
    }

    private static File findConfigInHomeDir() {
        File config = new File(new File(System.getenv("HOME"), ".kube"), "config");
        if (config.exists()) {
            return config;
        }
        log.debug("Could not find ~/.kube/config");
        return null;
    }

    public static ClientBuilder cluster() throws IOException {
        ClientBuilder builder = new ClientBuilder();
        String host = System.getenv("KUBERNETES_SERVICE_HOST");
        String port = System.getenv("KUBERNETES_SERVICE_PORT");
        builder.setBasePath("https://" + host + ":" + port);
        String token = new String(Files.readAllBytes(Paths.get("/var/run/secrets/kubernetes.io/serviceaccount/token", new String[0])), Charset.defaultCharset());
        builder.setCertificateAuthority(Files.readAllBytes(Paths.get("/var/run/secrets/kubernetes.io/serviceaccount/ca.crt", new String[0])));
        builder.setAuthentication(new AccessTokenAuthentication(token));
        return builder;
    }

    public static ClientBuilder kubeconfig(KubeConfig config) throws IOException {
        byte[] caBytes;
        ClientBuilder builder = new ClientBuilder();
        String server = config.getServer();
        if (!server.contains("://")) {
            server = server.contains(":443") ? "https://" + server : "http://" + server;
        }
        if ((caBytes = KubeConfig.getDataOrFile(config.getCertificateAuthorityData(), config.getCertificateAuthorityFile())) != null) {
            builder.setCertificateAuthority(caBytes);
        }
        builder.setVerifyingSsl(config.verifySSL());
        builder.setBasePath(server);
        builder.setAuthentication(new KubeconfigAuthentication(config));
        return builder;
    }

    public String getBasePath() {
        return this.basePath;
    }

    public ClientBuilder setBasePath(String basePath) {
        this.basePath = basePath;
        return this;
    }

    public Authentication getAuthentication() {
        return this.authentication;
    }

    public ClientBuilder setAuthentication(Authentication authentication) {
        this.authentication = authentication;
        return this;
    }

    public ClientBuilder setCertificateAuthority(byte[] caCertBytes) {
        this.caCertBytes = caCertBytes;
        return this;
    }

    public boolean isVerifyingSsl() {
        return this.verifyingSsl;
    }

    public ClientBuilder setVerifyingSsl(boolean verifyingSsl) {
        this.verifyingSsl = verifyingSsl;
        return this;
    }

    public ApiClient build() {
        ApiClient client = new ApiClient();
        if (this.basePath != null) {
            if (this.basePath.endsWith("/")) {
                this.basePath = this.basePath.substring(0, this.basePath.length() - 1);
            }
            client.setBasePath(this.basePath);
        }
        client.setVerifyingSsl(this.verifyingSsl);
        if (this.authentication != null) {
            this.authentication.provide(client);
        }
        if (this.caCertBytes != null) {
            client.setSslCaCert(new ByteArrayInputStream(this.caCertBytes));
        }
        return client;
    }
}

