/*
 * Decompiled with CFR 0.152.
 */
package io.kubernetes.client.examples;

import io.kubernetes.client.extended.controller.Controller;
import io.kubernetes.client.extended.controller.reconciler.Reconciler;
import io.kubernetes.client.extended.controller.reconciler.Request;
import io.kubernetes.client.extended.controller.reconciler.Result;
import io.kubernetes.client.informer.SharedInformer;
import io.kubernetes.client.informer.SharedInformerFactory;
import io.kubernetes.client.informer.cache.Lister;
import io.kubernetes.client.openapi.ApiClient;
import io.kubernetes.client.openapi.models.V1Node;
import io.kubernetes.client.openapi.models.V1NodeList;
import io.kubernetes.client.openapi.models.V1Pod;
import io.kubernetes.client.openapi.models.V1PodList;
import io.kubernetes.client.spring.extended.controller.annotation.GroupVersionResource;
import io.kubernetes.client.spring.extended.controller.annotation.KubernetesInformer;
import io.kubernetes.client.spring.extended.controller.annotation.KubernetesInformers;
import io.kubernetes.client.spring.extended.controller.annotation.KubernetesReconciler;
import io.kubernetes.client.spring.extended.controller.annotation.KubernetesReconcilerReadyFunc;
import io.kubernetes.client.spring.extended.controller.annotation.KubernetesReconcilerWatch;
import io.kubernetes.client.spring.extended.controller.annotation.KubernetesReconcilerWatches;
import io.kubernetes.client.util.ClientBuilder;
import java.io.IOException;
import java.time.Duration;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.boot.CommandLineRunner;
import org.springframework.boot.SpringApplication;
import org.springframework.boot.autoconfigure.SpringBootApplication;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.ComponentScan;
import org.springframework.context.annotation.Configuration;

@SpringBootApplication
public class SpringControllerExample {
    public static void main(String[] args) {
        SpringApplication.run(SpringControllerExample.class, (String[])args);
    }

    @KubernetesReconciler(value="node-printing-controller", watches=@KubernetesReconcilerWatches(value={@KubernetesReconcilerWatch(apiTypeClass=V1Node.class, resyncPeriodMillis=60000L)}))
    public static class NodePrintingReconciler
    implements Reconciler {
        private SharedInformer<V1Node> nodeInformer;
        private Lister<V1Node> nodeLister;
        private Lister<V1Pod> podLister;

        public NodePrintingReconciler(Lister<V1Pod> podLister, Lister<V1Node> nodeLister, SharedInformer<V1Node> nodeInformer) {
            this.nodeLister = nodeLister;
            this.podLister = podLister;
            this.nodeInformer = nodeInformer;
        }

        @KubernetesReconcilerReadyFunc
        boolean informerReady() {
            return this.nodeInformer.hasSynced();
        }

        public Result reconcile(Request request) {
            V1Node node = (V1Node)this.nodeLister.get(request.getName());
            System.out.println("triggered reconciling " + node.getMetadata().getName());
            return new Result(false);
        }
    }

    @KubernetesInformers(value={@KubernetesInformer(apiTypeClass=V1Node.class, apiListTypeClass=V1NodeList.class, groupVersionResource=@GroupVersionResource(apiGroup="", apiVersion="v1", resourcePlural="nodes"), resyncPeriodMillis=60000L), @KubernetesInformer(apiTypeClass=V1Pod.class, apiListTypeClass=V1PodList.class, groupVersionResource=@GroupVersionResource(apiGroup="", apiVersion="v1", resourcePlural="pods"))})
    public static class MySharedInformerFactory
    extends SharedInformerFactory {
    }

    @Configuration
    @ComponentScan(basePackages={"io.kubernetes.client.spring.extended.controller"})
    public static class AppConfig {
        @Bean
        public CommandLineRunner commandLineRunner(SharedInformerFactory sharedInformerFactory, @Qualifier(value="node-printing-controller") Controller nodePrintingController) {
            return args -> {
                System.out.println("starting informers..");
                sharedInformerFactory.startAllRegisteredInformers();
                System.out.println("running controller..");
                nodePrintingController.run();
            };
        }

        @Bean
        public ApiClient myApiClient() throws IOException {
            ApiClient apiClient = ClientBuilder.standard().build();
            return apiClient.setHttpClient(apiClient.getHttpClient().newBuilder().readTimeout(Duration.ZERO).build());
        }

        @Bean(value={"sharedInformerFactory"})
        public SharedInformerFactory sharedInformerFactory() {
            return new MySharedInformerFactory();
        }

        @Bean
        public NodePrintingReconciler nodePrintingReconciler(Lister<V1Pod> podLister, Lister<V1Node> nodeLister, SharedInformer<V1Node> nodeInformer) {
            return new NodePrintingReconciler(podLister, nodeLister, nodeInformer);
        }
    }
}

