/*
 * Decompiled with CFR 0.152.
 */
package io.kubernetes.client.examples;

import io.kubernetes.client.common.KubernetesObject;
import io.kubernetes.client.custom.V1Patch;
import io.kubernetes.client.openapi.ApiClient;
import io.kubernetes.client.openapi.models.V1Container;
import io.kubernetes.client.openapi.models.V1ObjectMeta;
import io.kubernetes.client.openapi.models.V1Pod;
import io.kubernetes.client.openapi.models.V1PodList;
import io.kubernetes.client.openapi.models.V1PodSpec;
import io.kubernetes.client.util.ClientBuilder;
import io.kubernetes.client.util.generic.GenericKubernetesApi;
import io.kubernetes.client.util.generic.KubernetesApiResponse;
import java.util.Arrays;

public class GenericClientExample {
    public static void main(String[] args) throws Exception {
        V1Pod pod = new V1Pod().metadata(new V1ObjectMeta().name("foo").namespace("default")).spec(new V1PodSpec().containers(Arrays.asList(new V1Container().name("c").image("test"))));
        ApiClient apiClient = ClientBuilder.standard().build();
        GenericKubernetesApi podClient = new GenericKubernetesApi(V1Pod.class, V1PodList.class, "", "v1", "pods", apiClient);
        KubernetesApiResponse createResponse = podClient.create((KubernetesObject)pod);
        if (!createResponse.isSuccess()) {
            throw new RuntimeException(createResponse.getStatus().toString());
        }
        System.out.println("Created!");
        KubernetesApiResponse patchResponse = podClient.patch("default", "foo", "application/strategic-merge-patch+json", new V1Patch("{\"metadata\":{\"finalizers\":[\"example.io/foo\"]}}"));
        if (!patchResponse.isSuccess()) {
            throw new RuntimeException(patchResponse.getStatus().toString());
        }
        System.out.println("Patched!");
        KubernetesApiResponse deleteResponse = podClient.delete("default", "foo");
        if (!deleteResponse.isSuccess()) {
            throw new RuntimeException(deleteResponse.getStatus().toString());
        }
        if (deleteResponse.getObject() != null) {
            System.out.println("Received after-deletion status of the requested object, will be deleting in background!");
        }
        System.out.println("Deleted!");
    }
}

