/*
 * Decompiled with CFR 0.152.
 */
package io.kubernetes.client.examples;

import com.google.common.io.ByteStreams;
import io.kubernetes.client.PortForward;
import io.kubernetes.client.openapi.ApiClient;
import io.kubernetes.client.openapi.ApiException;
import io.kubernetes.client.openapi.Configuration;
import io.kubernetes.client.util.Config;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.ServerSocket;
import java.net.Socket;
import java.util.ArrayList;

public class PortForwardExample {
    public static void main(String[] args) throws IOException, ApiException, InterruptedException {
        ApiClient client = Config.defaultClient();
        Configuration.setDefaultApiClient((ApiClient)client);
        PortForward forward = new PortForward();
        ArrayList<Integer> ports = new ArrayList<Integer>();
        ports.add(8080);
        ports.add(80);
        final PortForward.PortForwardResult result = forward.forward("default", "nginx-d5dc44cf7-x7475", ports);
        ServerSocket ss = new ServerSocket(8080);
        final Socket s = ss.accept();
        System.out.println("Connected!");
        new Thread(new Runnable(){

            @Override
            public void run() {
                try {
                    ByteStreams.copy((InputStream)result.getInputStream(80), (OutputStream)s.getOutputStream());
                }
                catch (IOException ex) {
                    ex.printStackTrace();
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
            }
        }).start();
        new Thread(new Runnable(){

            @Override
            public void run() {
                try {
                    ByteStreams.copy((InputStream)s.getInputStream(), (OutputStream)result.getOutboundStream(80));
                }
                catch (IOException ex) {
                    ex.printStackTrace();
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
            }
        }).start();
        Thread.sleep(10000L);
        System.exit(0);
    }
}

