/*
 * Decompiled with CFR 0.152.
 */
package io.kubernetes.client.examples;

import io.kubernetes.client.custom.V1Patch;
import io.kubernetes.client.openapi.ApiClient;
import io.kubernetes.client.openapi.ApiException;
import io.kubernetes.client.openapi.Configuration;
import io.kubernetes.client.openapi.apis.ExtensionsV1beta1Api;
import io.kubernetes.client.openapi.models.ExtensionsV1beta1Deployment;
import io.kubernetes.client.util.ClientBuilder;
import java.io.IOException;

public class PatchExample {
    static String jsonPatchStr = "[{\"op\":\"replace\",\"path\":\"/spec/template/spec/terminationGracePeriodSeconds\",\"value\":27}]";
    static String strategicMergePatchStr = "{\"metadata\":{\"$deleteFromPrimitiveList/finalizers\":[\"example.com/test\"]}}";
    static String jsonDeploymentStr = "{\"kind\":\"Deployment\",\"apiVersion\":\"extensions/v1beta1\",\"metadata\":{\"name\":\"hello-node\",\"finalizers\":[\"example.com/test\"],\"labels\":{\"run\":\"hello-node\"}},\"spec\":{\"replicas\":1,\"selector\":{\"matchLabels\":{\"run\":\"hello-node\"}},\"template\":{\"metadata\":{\"creationTimestamp\":null,\"labels\":{\"run\":\"hello-node\"}},\"spec\":{\"terminationGracePeriodSeconds\":30,\"containers\":[{\"name\":\"hello-node\",\"image\":\"hello-node:v1\",\"ports\":[{\"containerPort\":8080}],\"resources\":{}}]}},\"strategy\":{}},\"status\":{}}";
    static String applyYamlStr = "{\"kind\":\"Deployment\",\"apiVersion\":\"extensions/v1beta1\",\"metadata\":{\"name\":\"hello-node\",\"finalizers\":[\"example.com/test\"],\"labels\":{\"run\":\"hello-node\"}},\"spec\":{\"replicas\":1,\"selector\":{\"matchLabels\":{\"run\":\"hello-node\"}},\"template\":{\"metadata\":{\"creationTimestamp\":null,\"labels\":{\"run\":\"hello-node\"}},\"spec\":{\"terminationGracePeriodSeconds\":30,\"containers\":[{\"name\":\"hello-node\",\"image\":\"hello-node:v2\",\"ports\":[{\"containerPort\":8080}],\"resources\":{}}]}},\"strategy\":{}},\"status\":{}}";

    public static void main(String[] args) throws IOException {
        try {
            ExtensionsV1beta1Api api = new ExtensionsV1beta1Api(ClientBuilder.standard().build());
            ExtensionsV1beta1Deployment body = (ExtensionsV1beta1Deployment)Configuration.getDefaultApiClient().getJSON().deserialize(jsonDeploymentStr, ExtensionsV1beta1Deployment.class);
            ExtensionsV1beta1Deployment deploy1 = api.createNamespacedDeployment("default", body, null, null, null);
            System.out.println("original deployment" + deploy1);
            ApiClient jsonPatchClient = ClientBuilder.standard().setOverridePatchFormat("application/json-patch+json").build();
            ExtensionsV1beta1Deployment deploy2 = new ExtensionsV1beta1Api(jsonPatchClient).patchNamespacedDeployment("hello-node", "default", (Object)new V1Patch(jsonPatchStr), null, null, null, null);
            System.out.println("json-patched deployment" + deploy2);
            ApiClient strategicMergePatchClient = ClientBuilder.standard().setOverridePatchFormat("application/strategic-merge-patch+json").build();
            strategicMergePatchClient.setDebugging(true);
            ExtensionsV1beta1Deployment deploy3 = new ExtensionsV1beta1Api(strategicMergePatchClient).patchNamespacedDeployment("hello-node", "default", (Object)new V1Patch(strategicMergePatchStr), null, null, null, null);
            System.out.println("strategic-merge-patched deployment" + deploy3);
            ApiClient applyYamlClient = ClientBuilder.standard().setOverridePatchFormat("application/apply-patch+yaml").build();
            applyYamlClient.setDebugging(true);
            ExtensionsV1beta1Deployment deploy4 = new ExtensionsV1beta1Api(applyYamlClient).patchNamespacedDeployment("hello-node", "default", (Object)new V1Patch(applyYamlStr), null, null, null, null);
            System.out.println("application/apply-patch+yaml deployment" + deploy4);
        }
        catch (ApiException e) {
            System.out.println(e.getResponseBody());
            e.printStackTrace();
        }
    }
}

