/*
 * Decompiled with CFR 0.152.
 */
package io.kubernetes.client.examples;

import io.kubernetes.client.openapi.ApiClient;
import io.kubernetes.client.openapi.ApiException;
import io.kubernetes.client.openapi.Configuration;
import io.kubernetes.client.openapi.apis.CoreV1Api;
import io.kubernetes.client.openapi.apis.ExtensionsV1beta1Api;
import io.kubernetes.client.openapi.models.ExtensionsV1beta1Deployment;
import io.kubernetes.client.openapi.models.ExtensionsV1beta1DeploymentList;
import io.kubernetes.client.openapi.models.ExtensionsV1beta1DeploymentSpec;
import io.kubernetes.client.openapi.models.V1NamespaceList;
import io.kubernetes.client.openapi.models.V1PodList;
import io.kubernetes.client.openapi.models.V1ServiceList;
import io.kubernetes.client.util.Config;
import java.io.IOException;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ExpandedExample {
    private static CoreV1Api COREV1_API;
    private static final String DEFAULT_NAME_SPACE = "default";
    private static final Integer TIME_OUT_VALUE;
    private static final Logger LOGGER;

    public static void main(String[] args) {
        try {
            ApiClient client = Config.defaultClient();
            Configuration.setDefaultApiClient((ApiClient)client);
            COREV1_API = new CoreV1Api(client);
            System.out.println("----- Scale Deployment Start -----");
            ExpandedExample.scaleDeployment("account-service", 5);
            List<String> nameSpaces = ExpandedExample.getAllNameSpaces();
            nameSpaces.stream().forEach(namespace -> {
                try {
                    System.out.println("----- " + namespace + " -----");
                    ExpandedExample.getNamespacedPod(namespace).stream().forEach(System.out::println);
                }
                catch (ApiException ex) {
                    LOGGER.warn("Couldn't get the pods in namespace:" + namespace, (Throwable)ex);
                }
            });
            System.out.println("----- Print list all Services Start -----");
            List<String> services = ExpandedExample.getServices();
            services.stream().forEach(System.out::println);
            System.out.println("----- Print list all Services End -----");
            System.out.println("----- Print Log of Specific Pod Start -----");
            String firstPodName = ExpandedExample.getPods().get(0);
            ExpandedExample.printLog(DEFAULT_NAME_SPACE, firstPodName);
            System.out.println("----- Print Log of Specific Pod End -----");
        }
        catch (ApiException | IOException ex) {
            LOGGER.warn("Exception had occured ", ex);
        }
    }

    public static List<String> getAllNameSpaces() throws ApiException {
        V1NamespaceList listNamespace = COREV1_API.listNamespace("true", null, null, null, null, Integer.valueOf(0), null, Integer.valueOf(Integer.MAX_VALUE), Boolean.FALSE);
        List<String> list = listNamespace.getItems().stream().map(v1Namespace -> v1Namespace.getMetadata().getName()).collect(Collectors.toList());
        return list;
    }

    public static List<String> getPods() throws ApiException {
        V1PodList v1podList = COREV1_API.listPodForAllNamespaces(null, null, null, null, null, null, null, null, null);
        List<String> podList = v1podList.getItems().stream().map(v1Pod -> v1Pod.getMetadata().getName()).collect(Collectors.toList());
        return podList;
    }

    public static List<String> getNamespacedPod() throws ApiException {
        return ExpandedExample.getNamespacedPod(DEFAULT_NAME_SPACE, null);
    }

    public static List<String> getNamespacedPod(String namespace) throws ApiException {
        return ExpandedExample.getNamespacedPod(namespace, null);
    }

    public static List<String> getNamespacedPod(String namespace, String label) throws ApiException {
        V1PodList listNamespacedPod = COREV1_API.listNamespacedPod(namespace, null, null, null, null, label, Integer.valueOf(Integer.MAX_VALUE), null, TIME_OUT_VALUE, Boolean.FALSE);
        List<String> listPods = listNamespacedPod.getItems().stream().map(v1pod -> v1pod.getMetadata().getName()).collect(Collectors.toList());
        return listPods;
    }

    public static List<String> getServices() throws ApiException {
        V1ServiceList listNamespacedService = COREV1_API.listNamespacedService(DEFAULT_NAME_SPACE, null, null, null, null, null, Integer.valueOf(Integer.MAX_VALUE), null, TIME_OUT_VALUE, Boolean.FALSE);
        return listNamespacedService.getItems().stream().map(v1service -> v1service.getMetadata().getName()).collect(Collectors.toList());
    }

    public static void scaleDeployment(String deploymentName, int numberOfReplicas) throws ApiException {
        ExtensionsV1beta1Api extensionV1Api = new ExtensionsV1beta1Api();
        extensionV1Api.setApiClient(COREV1_API.getApiClient());
        ExtensionsV1beta1DeploymentList listNamespacedDeployment = extensionV1Api.listNamespacedDeployment(DEFAULT_NAME_SPACE, null, null, null, null, null, null, null, null, Boolean.FALSE);
        List extensionsV1beta1DeploymentItems = listNamespacedDeployment.getItems();
        Optional<ExtensionsV1beta1Deployment> findedDeployment = extensionsV1beta1DeploymentItems.stream().filter(deployment -> deployment.getMetadata().getName().equals(deploymentName)).findFirst();
        findedDeployment.ifPresent(deploy -> {
            try {
                ExtensionsV1beta1DeploymentSpec newSpec = deploy.getSpec().replicas(Integer.valueOf(numberOfReplicas));
                ExtensionsV1beta1Deployment newDeploy = deploy.spec(newSpec);
                extensionV1Api.replaceNamespacedDeployment(deploymentName, DEFAULT_NAME_SPACE, newDeploy, null, null, null);
            }
            catch (ApiException ex) {
                LOGGER.warn("Scale the pod failed for Deployment:" + deploymentName, (Throwable)ex);
            }
        });
    }

    public static void printLog(String namespace, String podName) throws ApiException {
        String readNamespacedPodLog = COREV1_API.readNamespacedPodLog(podName, namespace, null, Boolean.FALSE, Integer.valueOf(Integer.MAX_VALUE), null, Boolean.FALSE, Integer.valueOf(Integer.MAX_VALUE), Integer.valueOf(40), Boolean.FALSE);
        System.out.println(readNamespacedPodLog);
    }

    static {
        TIME_OUT_VALUE = 180;
        LOGGER = LoggerFactory.getLogger(ExpandedExample.class);
    }
}

