/*
 * Decompiled with CFR 0.152.
 */
package io.kubernetes.client.examples;

import com.google.common.io.ByteStreams;
import io.kubernetes.client.Exec;
import io.kubernetes.client.openapi.ApiClient;
import io.kubernetes.client.openapi.ApiException;
import io.kubernetes.client.openapi.Configuration;
import io.kubernetes.client.util.Config;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.DefaultParser;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;

public class ExecExample {
    public static void main(String[] args) throws IOException, ApiException, InterruptedException, ParseException {
        String[] stringArray;
        boolean tty;
        Options options = new Options();
        options.addOption(new Option("p", "pod", true, "The name of the pod"));
        options.addOption(new Option("n", "namespace", true, "The namespace of the pod"));
        DefaultParser parser = new DefaultParser();
        CommandLine cmd = parser.parse(options, args);
        String podName = cmd.getOptionValue("p", "nginx-dbddb74b8-s4cx5");
        String namespace = cmd.getOptionValue("n", "default");
        ArrayList<String> commands = new ArrayList<String>();
        args = cmd.getArgs();
        for (int i = 0; i < args.length; ++i) {
            commands.add(args[i]);
        }
        ApiClient client = Config.defaultClient();
        Configuration.setDefaultApiClient((ApiClient)client);
        Exec exec = new Exec();
        boolean bl = tty = System.console() != null;
        if (commands.isEmpty()) {
            String[] stringArray2 = new String[1];
            stringArray = stringArray2;
            stringArray2[0] = "sh";
        } else {
            stringArray = commands.toArray(new String[commands.size()]);
        }
        final Process proc = exec.exec(namespace, podName, stringArray, true, tty);
        Thread in = new Thread(new Runnable(){

            @Override
            public void run() {
                try {
                    ByteStreams.copy((InputStream)System.in, (OutputStream)proc.getOutputStream());
                }
                catch (IOException ex) {
                    ex.printStackTrace();
                }
            }
        });
        in.start();
        Thread out = new Thread(new Runnable(){

            @Override
            public void run() {
                try {
                    ByteStreams.copy((InputStream)proc.getInputStream(), (OutputStream)System.out);
                }
                catch (IOException ex) {
                    ex.printStackTrace();
                }
            }
        });
        out.start();
        proc.waitFor();
        out.join();
        proc.destroy();
        System.exit(proc.exitValue());
    }
}

