/*
 * Decompiled with CFR 0.152.
 */
package io.kubernetes.client.examples;

import io.kubernetes.client.ApiClient;
import io.kubernetes.client.ApiException;
import io.kubernetes.client.Configuration;
import io.kubernetes.client.apis.CoreV1Api;
import io.kubernetes.client.informer.ResourceEventHandler;
import io.kubernetes.client.informer.SharedIndexInformer;
import io.kubernetes.client.informer.SharedInformerFactory;
import io.kubernetes.client.informer.cache.Lister;
import io.kubernetes.client.models.V1Node;
import io.kubernetes.client.models.V1NodeList;
import io.kubernetes.client.models.V1ObjectMeta;
import io.kubernetes.client.util.Config;

public class InformerExample {
    public static void main(String[] args) throws Exception {
        ApiClient client = Config.defaultClient();
        Configuration.setDefaultApiClient((ApiClient)client);
        SharedInformerFactory factory = new SharedInformerFactory();
        CoreV1Api coreV1Api = new CoreV1Api();
        SharedIndexInformer nodeInformer = factory.sharedIndexInformerFor(params -> {
            try {
                return coreV1Api.listNodeCall(null, null, null, null, null, null, params.resourceVersion, params.timeoutSeconds, params.watch, null, null);
            }
            catch (ApiException e) {
                throw new RuntimeException(e);
            }
        }, V1Node.class, V1NodeList.class);
        nodeInformer.addEventHandler((ResourceEventHandler)new ResourceEventHandler<V1Node>(){

            public void onAdd(V1Node node) {
                System.out.printf("%s node added!\n", node.getMetadata().getName());
            }

            public void onUpdate(V1Node oldNode, V1Node newNode) {
                System.out.printf("%s => %s node updated!\n", oldNode.getMetadata().getName(), newNode.getMetadata().getName());
            }

            public void onDelete(V1Node node, boolean deletedFinalStateUnknown) {
                System.out.printf("%s node deleted!\n", node.getMetadata().getName());
            }
        });
        factory.startAllRegisteredInformers();
        V1Node nodeToCreate = new V1Node();
        V1ObjectMeta metadata = new V1ObjectMeta();
        metadata.setName("noxu");
        nodeToCreate.setMetadata(metadata);
        String s = coreV1Api.getApiClient().getJSON().serialize((Object)nodeToCreate);
        V1Node createdNode = coreV1Api.createNode(nodeToCreate, null, null, null);
        Thread.sleep(3000L);
        Lister nodeLister = new Lister(nodeInformer.getIndexer());
        V1Node node = (V1Node)nodeLister.get("noxu");
        System.out.printf("noxu created! %s\n", node.getMetadata().getCreationTimestamp());
        factory.stopAllRegisteredInformers();
        Thread.sleep(3000L);
        System.out.println("informer stopped..");
    }
}

