/*
 * Decompiled with CFR 0.152.
 */
package io.kubernetes.client.custom;

import io.kubernetes.client.custom.BaseExponent;
import io.kubernetes.client.custom.Quantity;
import io.kubernetes.client.custom.QuantityFormatException;
import io.kubernetes.client.custom.SuffixFormatter;
import org.hamcrest.Matcher;
import org.hamcrest.core.Is;
import org.junit.Assert;
import org.junit.Test;

public class SuffixFormatterTest {
    @Test
    public void testParseBinaryKi() {
        BaseExponent baseExponent = new SuffixFormatter().parse("Ki");
        Assert.assertThat((Object)baseExponent.getBase(), (Matcher)Is.is((Object)2));
        Assert.assertThat((Object)baseExponent.getExponent(), (Matcher)Is.is((Object)10));
        Assert.assertThat((Object)baseExponent.getFormat(), (Matcher)Is.is((Object)Quantity.Format.BINARY_SI));
    }

    @Test
    public void testParseDecimalZero() {
        BaseExponent baseExponent = new SuffixFormatter().parse("");
        Assert.assertThat((Object)baseExponent.getBase(), (Matcher)Is.is((Object)10));
        Assert.assertThat((Object)baseExponent.getExponent(), (Matcher)Is.is((Object)0));
        Assert.assertThat((Object)baseExponent.getFormat(), (Matcher)Is.is((Object)Quantity.Format.DECIMAL_SI));
    }

    @Test
    public void testParseDecimalK() {
        BaseExponent baseExponent = new SuffixFormatter().parse("k");
        Assert.assertThat((Object)baseExponent.getBase(), (Matcher)Is.is((Object)10));
        Assert.assertThat((Object)baseExponent.getExponent(), (Matcher)Is.is((Object)3));
        Assert.assertThat((Object)baseExponent.getFormat(), (Matcher)Is.is((Object)Quantity.Format.DECIMAL_SI));
    }

    @Test
    public void testParseDecimalExponent() {
        BaseExponent baseExponent = new SuffixFormatter().parse("E2");
        Assert.assertThat((Object)baseExponent.getBase(), (Matcher)Is.is((Object)10));
        Assert.assertThat((Object)baseExponent.getExponent(), (Matcher)Is.is((Object)2));
        Assert.assertThat((Object)baseExponent.getFormat(), (Matcher)Is.is((Object)Quantity.Format.DECIMAL_EXPONENT));
    }

    @Test
    public void testParseDecimalExponentPositive() {
        BaseExponent baseExponent = new SuffixFormatter().parse("e+3");
        Assert.assertThat((Object)baseExponent.getBase(), (Matcher)Is.is((Object)10));
        Assert.assertThat((Object)baseExponent.getExponent(), (Matcher)Is.is((Object)3));
        Assert.assertThat((Object)baseExponent.getFormat(), (Matcher)Is.is((Object)Quantity.Format.DECIMAL_EXPONENT));
    }

    @Test
    public void testParseDecimalExponentNegative() {
        BaseExponent baseExponent = new SuffixFormatter().parse("e-3");
        Assert.assertThat((Object)baseExponent.getBase(), (Matcher)Is.is((Object)10));
        Assert.assertThat((Object)baseExponent.getExponent(), (Matcher)Is.is((Object)-3));
        Assert.assertThat((Object)baseExponent.getFormat(), (Matcher)Is.is((Object)Quantity.Format.DECIMAL_EXPONENT));
    }

    @Test(expected=QuantityFormatException.class)
    public void testParseBad() {
        new SuffixFormatter().parse("eKi");
    }

    @Test
    public void testFormatZeroDecimalExponent() {
        String formattedString = new SuffixFormatter().format(Quantity.Format.DECIMAL_EXPONENT, 0);
        Assert.assertThat((Object)formattedString, (Matcher)Is.is((Object)""));
    }

    @Test
    public void testFormatDecimalExponent() {
        String formattedString = new SuffixFormatter().format(Quantity.Format.DECIMAL_EXPONENT, 3);
        Assert.assertThat((Object)formattedString, (Matcher)Is.is((Object)"e3"));
    }

    @Test
    public void testFormatZeroDecimalSi() {
        String formattedString = new SuffixFormatter().format(Quantity.Format.DECIMAL_SI, 0);
        Assert.assertThat((Object)formattedString, (Matcher)Is.is((Object)""));
    }

    @Test(expected=IllegalArgumentException.class)
    public void testFormatBadDecimalSi() {
        new SuffixFormatter().format(Quantity.Format.DECIMAL_SI, 2);
    }

    @Test
    public void testFormatDecimalSi() {
        String formattedString = new SuffixFormatter().format(Quantity.Format.DECIMAL_SI, 3);
        Assert.assertThat((Object)formattedString, (Matcher)Is.is((Object)"k"));
    }

    @Test
    public void testFormatNegativeDecimalSi() {
        String formattedString = new SuffixFormatter().format(Quantity.Format.DECIMAL_SI, -6);
        Assert.assertThat((Object)formattedString, (Matcher)Is.is((Object)"u"));
    }

    @Test
    public void testFormatBinarySi() {
        String formattedString = new SuffixFormatter().format(Quantity.Format.BINARY_SI, 10);
        Assert.assertThat((Object)formattedString, (Matcher)Is.is((Object)"Ki"));
    }

    @Test
    public void testFormatNoExponentBinarySi() {
        String formattedString = new SuffixFormatter().format(Quantity.Format.BINARY_SI, 0);
        Assert.assertThat((Object)formattedString, (Matcher)Is.is((Object)""));
    }

    @Test(expected=IllegalArgumentException.class)
    public void testFormatBadBinarySi() {
        new SuffixFormatter().format(Quantity.Format.BINARY_SI, 4);
    }
}

