/*
 * Decompiled with CFR 0.152.
 */
package io.kubernetes.client.custom;

import io.kubernetes.client.custom.IntOrString;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Test;

public class IntOrStringTest {
    @Test
    public void whenCreatedWithInt_isInteger() {
        IntOrString intOrString = new IntOrString(17);
        Assert.assertThat((Object)intOrString.isInteger(), (Matcher)Matchers.is((Object)true));
    }

    @Test
    public void whenCreatedWithInt_canRetrieveIntValue() {
        IntOrString intOrString = new IntOrString(17);
        Assert.assertThat((Object)intOrString.getIntValue(), (Matcher)Matchers.equalTo((Object)17));
    }

    @Test(expected=IllegalStateException.class)
    public void whenCreatedWithInt_cannotRetrieveStringValue() {
        IntOrString intOrString = new IntOrString(17);
        intOrString.getStrValue();
    }

    @Test
    public void whenCreatedWithInt_equalsItself() {
        IntOrString intOrString = new IntOrString(17);
        Assert.assertThat((Object)intOrString, (Matcher)Matchers.equalTo((Object)intOrString));
    }

    @Test
    public void whenCreatedWithInt_equalsAnotherWithSameValue() {
        IntOrString intOrString1 = new IntOrString(17);
        IntOrString intOrString2 = new IntOrString(17);
        Assert.assertThat((Object)intOrString1, (Matcher)Matchers.equalTo((Object)intOrString2));
    }

    @Test
    public void whenCreatedWithInt_notEqualAnotherWithDifferentValue() {
        IntOrString intOrString1 = new IntOrString(17);
        IntOrString intOrString2 = new IntOrString(13);
        Assert.assertThat((Object)intOrString1, (Matcher)Matchers.not((Matcher)Matchers.equalTo((Object)intOrString2)));
    }

    @Test
    public void whenCreatedWithInt_notEqualOneCreatedFromString() {
        IntOrString intOrString1 = new IntOrString(17);
        IntOrString intOrString2 = new IntOrString("17");
        Assert.assertThat((Object)intOrString1, (Matcher)Matchers.not((Matcher)Matchers.equalTo((Object)intOrString2)));
    }

    @Test
    public void whenCreatedWithString_isNotInteger() {
        IntOrString intOrString = new IntOrString("17");
        Assert.assertThat((Object)intOrString.isInteger(), (Matcher)Matchers.is((Object)false));
    }

    @Test(expected=IllegalStateException.class)
    public void whenCreatedWithInt_cannotRetrieveIntValue() {
        IntOrString intOrString = new IntOrString("17");
        intOrString.getIntValue();
    }

    @Test
    public void whenCreatedWithString_canRetrieveStringValue() {
        IntOrString intOrString = new IntOrString("17");
        Assert.assertThat((Object)intOrString.getStrValue(), (Matcher)Matchers.equalTo((Object)"17"));
    }

    @Test
    public void whenCreatedWithString_equalsItself() {
        IntOrString intOrString = new IntOrString("17");
        Assert.assertThat((Object)intOrString, (Matcher)Matchers.equalTo((Object)intOrString));
    }

    @Test
    public void whenCreatedWithString_equalsAnotherWithSameValue() {
        IntOrString intOrString1 = new IntOrString("17");
        IntOrString intOrString2 = new IntOrString("17");
        Assert.assertThat((Object)intOrString1, (Matcher)Matchers.equalTo((Object)intOrString2));
    }

    @Test
    public void whenCreatedWithString_notEqualAnotherWithDifferentValue() {
        IntOrString intOrString1 = new IntOrString("17");
        IntOrString intOrString2 = new IntOrString("13");
        Assert.assertThat((Object)intOrString1, (Matcher)Matchers.not((Matcher)Matchers.equalTo((Object)intOrString2)));
    }
}

