/*
 * Decompiled with CFR 0.152.
 */
package io.kotlintest.extensions.system;

import io.kotlintest.Description;
import io.kotlintest.Spec;
import io.kotlintest.TestResult;
import io.kotlintest.extensions.TestListener;
import io.kotlintest.extensions.system.NoExitSecurityManager;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 10}, bv={1, 0, 2}, k=1, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\u00052\u0006\u0010\n\u001a\u00020\u000bH\u0016J\u0018\u0010\f\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\u00052\u0006\u0010\n\u001a\u00020\u000bH\u0016R\u001a\u0010\u0003\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00060\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\r"}, d2={"Lio/kotlintest/extensions/system/SpecSystemExitListener;", "Lio/kotlintest/extensions/TestListener;", "()V", "previousSecurityManagers", "Ljava/util/concurrent/ConcurrentHashMap;", "Lio/kotlintest/Description;", "Ljava/lang/SecurityManager;", "afterSpec", "", "description", "spec", "Lio/kotlintest/Spec;", "beforeSpec", "kotlintest-extensions-system"})
public final class SpecSystemExitListener
implements TestListener {
    private static final ConcurrentHashMap<Description, SecurityManager> previousSecurityManagers;
    public static final SpecSystemExitListener INSTANCE;

    public void beforeSpec(@NotNull Description description, @NotNull Spec spec) {
        Intrinsics.checkParameterIsNotNull((Object)description, (String)"description");
        Intrinsics.checkParameterIsNotNull((Object)spec, (String)"spec");
        SecurityManager previous = System.getSecurityManager();
        if (previous != null) {
            Map map = previousSecurityManagers;
            SecurityManager securityManager = previous;
            map.put(description, securityManager);
        }
        System.setSecurityManager(new NoExitSecurityManager(previous));
    }

    public void afterSpec(@NotNull Description description, @NotNull Spec spec) {
        Intrinsics.checkParameterIsNotNull((Object)description, (String)"description");
        Intrinsics.checkParameterIsNotNull((Object)spec, (String)"spec");
        if (previousSecurityManagers.contains(description)) {
            System.setSecurityManager(previousSecurityManagers.get(description));
        } else {
            System.setSecurityManager(null);
        }
    }

    private SpecSystemExitListener() {
    }

    static {
        SpecSystemExitListener specSystemExitListener;
        INSTANCE = specSystemExitListener = new SpecSystemExitListener();
        previousSecurityManagers = new ConcurrentHashMap();
    }

    public void afterDiscovery(@NotNull List<Description> descriptions) {
        Intrinsics.checkParameterIsNotNull(descriptions, (String)"descriptions");
        TestListener.DefaultImpls.afterDiscovery((TestListener)this, descriptions);
    }

    public void afterProject() {
        TestListener.DefaultImpls.afterProject((TestListener)this);
    }

    public void afterTest(@NotNull Description description, @NotNull TestResult result) {
        Intrinsics.checkParameterIsNotNull((Object)description, (String)"description");
        Intrinsics.checkParameterIsNotNull((Object)result, (String)"result");
        TestListener.DefaultImpls.afterTest((TestListener)this, (Description)description, (TestResult)result);
    }

    public void beforeProject() {
        TestListener.DefaultImpls.beforeProject((TestListener)this);
    }

    public void beforeTest(@NotNull Description description) {
        Intrinsics.checkParameterIsNotNull((Object)description, (String)"description");
        TestListener.DefaultImpls.beforeTest((TestListener)this, (Description)description);
    }
}

