/*
 * Decompiled with CFR 0.152.
 */
package io.kotlintest.extensions.junitxml;

import io.kotlintest.Description;
import io.kotlintest.Spec;
import io.kotlintest.TestCase;
import io.kotlintest.TestResult;
import io.kotlintest.TestStatus;
import io.kotlintest.extensions.TestListener;
import io.kotlintest.extensions.TopLevelTest;
import io.kotlintest.extensions.junitxml.JUnitXmlListener$WhenMappings;
import java.io.File;
import java.io.FileWriter;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import kotlin.Deprecated;
import kotlin.Metadata;
import kotlin.ReplaceWith;
import kotlin.TypeCastException;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\u00072\u0006\u0010\f\u001a\u00020\rH\u0016J\u0018\u0010\u000e\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\u00072\u0006\u0010\u000f\u001a\u00020\bH\u0016R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0005\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\b0\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0010"}, d2={"Lio/kotlintest/extensions/junitxml/JUnitXmlListener;", "Lio/kotlintest/extensions/TestListener;", "()V", "outputDirectory", "", "results", "Ljava/util/concurrent/ConcurrentHashMap;", "Lio/kotlintest/Description;", "Lio/kotlintest/TestResult;", "afterSpec", "", "description", "spec", "Lio/kotlintest/Spec;", "afterTest", "result", "kotlintest-extensions-junitxml"})
public final class JUnitXmlListener
implements TestListener {
    private static final ConcurrentHashMap<Description, TestResult> results;
    private static final String outputDirectory;
    public static final JUnitXmlListener INSTANCE;

    /*
     * WARNING - void declaration
     */
    public void afterSpec(@NotNull Description description, @NotNull Spec spec) {
        Map $receiver$iv5;
        Map.Entry it;
        void $receiver$iv$iv;
        Map $receiver$iv;
        void $receiver$iv$iv2;
        Map $receiver$iv2;
        void $receiver$iv$iv3;
        Map testResults;
        Map $receiver$iv3;
        Object it2;
        Map.Entry entry$iv22;
        Intrinsics.checkParameterIsNotNull((Object)description, (String)"description");
        Intrinsics.checkParameterIsNotNull((Object)spec, (String)"spec");
        Map $receiver$iv4 = results;
        LinkedHashMap result$iv = new LinkedHashMap();
        Map map = $receiver$iv4;
        for (Map.Entry entry$iv22 : map.entrySet()) {
            it2 = (Description)entry$iv22.getKey();
            if (!it2.hasParent(description)) continue;
            result$iv.put(entry$iv22.getKey(), entry$iv22.getValue());
        }
        map = $receiver$iv3 = (testResults = (Map)result$iv);
        Map destination$iv$iv = new LinkedHashMap();
        entry$iv22 = $receiver$iv$iv3;
        for (Map.Entry object : entry$iv22.entrySet()) {
            Map.Entry it3 = object;
            if (!(((TestResult)it3.getValue()).getStatus() == TestStatus.Error)) continue;
            destination$iv$iv.put(object.getKey(), object.getValue());
        }
        Map errors = destination$iv$iv;
        destination$iv$iv = $receiver$iv2 = testResults;
        Map destination$iv$iv2 = new LinkedHashMap();
        it2 = $receiver$iv$iv2;
        for (Map.Entry element$iv$iv : it2.entrySet()) {
            Map.Entry it4 = element$iv$iv;
            if (!(((TestResult)it4.getValue()).getStatus() == TestStatus.Failure)) continue;
            destination$iv$iv2.put(element$iv$iv.getKey(), element$iv$iv.getValue());
        }
        Map failures = destination$iv$iv2;
        destination$iv$iv2 = $receiver$iv = testResults;
        Map destination$iv$iv3 = new LinkedHashMap();
        void var10_12 = $receiver$iv$iv;
        for (Map.Entry element$iv$iv : var10_12.entrySet()) {
            it = element$iv$iv;
            if (!(((TestResult)it.getValue()).getStatus() == TestStatus.Error)) continue;
            destination$iv$iv3.put(element$iv$iv.getKey(), element$iv$iv.getValue());
        }
        Map disabled = destination$iv$iv3;
        File file = new File(outputDirectory + '/' + description.fullName() + ".xml");
        file.getParentFile().mkdirs();
        FileWriter writer = new FileWriter(file);
        writer.write("<?xml version=\"1.0\" encoding=\"UTF-8\"?>");
        writer.write("<testsuite tests=\"" + testResults.size() + "\" failures=\"" + failures.size() + "\" disabled=\"" + disabled.size() + "\" errors=\"" + errors.size() + "\" time=\"0\" name=\"" + spec.name() + "\">");
        Map map2 = $receiver$iv5 = testResults;
        for (Map.Entry element$iv : map2.entrySet()) {
            it = element$iv;
            String string = StringsKt.drop((String)((Description)it.getKey()).fullName(), (int)description.getName().length());
            StringBuilder stringBuilder = new StringBuilder().append("<testcase name=\"");
            FileWriter fileWriter = writer;
            String string2 = string;
            if (string2 == null) {
                throw new TypeCastException("null cannot be cast to non-null type kotlin.CharSequence");
            }
            String string3 = ((Object)StringsKt.trim((CharSequence)string2)).toString();
            fileWriter.write(stringBuilder.append(string3).append("\" status=\"run\" time=\"0\" classname=\"").append(spec.getClass().getCanonicalName()).append("\">").toString());
            switch (JUnitXmlListener$WhenMappings.$EnumSwitchMapping$0[((TestResult)it.getValue()).getStatus().ordinal()]) {
                case 1: {
                    Throwable throwable = ((TestResult)it.getValue()).getError();
                    writer.write("<error message=\"" + (throwable != null ? throwable.getMessage() : null) + "\"/>");
                    break;
                }
                case 2: {
                    Throwable throwable = ((TestResult)it.getValue()).getError();
                    writer.write("<failure message=\"" + (throwable != null ? throwable.getMessage() : null) + "\"/>");
                    break;
                }
                case 3: {
                    writer.write("<skipped/>");
                }
            }
            writer.write("</testcase>");
        }
        writer.write("</testsuite>");
        writer.close();
    }

    public void afterTest(@NotNull Description description, @NotNull TestResult result) {
        Intrinsics.checkParameterIsNotNull((Object)description, (String)"description");
        Intrinsics.checkParameterIsNotNull((Object)result, (String)"result");
        Map map = results;
        TestResult testResult = result;
        map.put(description, testResult);
    }

    private JUnitXmlListener() {
    }

    static {
        JUnitXmlListener jUnitXmlListener;
        INSTANCE = jUnitXmlListener = new JUnitXmlListener();
        results = new ConcurrentHashMap();
        String string = System.getProperty("kotlintest.junit.report.directory");
        if (string == null) {
            string = "build/test-results";
        }
        outputDirectory = string;
    }

    public void afterSpec(@NotNull Spec spec) {
        Intrinsics.checkParameterIsNotNull((Object)spec, (String)"spec");
        TestListener.DefaultImpls.afterSpec((TestListener)this, (Spec)spec);
    }

    public void afterTest(@NotNull TestCase testCase, @NotNull TestResult result) {
        Intrinsics.checkParameterIsNotNull((Object)testCase, (String)"testCase");
        Intrinsics.checkParameterIsNotNull((Object)result, (String)"result");
        TestListener.DefaultImpls.afterTest((TestListener)this, (TestCase)testCase, (TestResult)result);
    }

    public void afterDiscovery(@NotNull List<Description> descriptions) {
        Intrinsics.checkParameterIsNotNull(descriptions, (String)"descriptions");
        TestListener.DefaultImpls.afterDiscovery((TestListener)this, descriptions);
    }

    public void afterProject() {
        TestListener.DefaultImpls.afterProject((TestListener)this);
    }

    public void afterSpecClass(@NotNull Spec spec, @NotNull Map<TestCase, TestResult> results) {
        Intrinsics.checkParameterIsNotNull((Object)spec, (String)"spec");
        Intrinsics.checkParameterIsNotNull(results, (String)"results");
        TestListener.DefaultImpls.afterSpecClass((TestListener)this, (Spec)spec, results);
    }

    @Deprecated(replaceWith=@ReplaceWith(imports={}, expression="afterSpecClass(Spec, Map<TestCase, TestResult>)"), message="use afterSpecClass(Spec, Map<TestCase, TestResult>) which provides the full test case instance")
    public void afterSpecCompleted(@NotNull Description description, @NotNull Spec spec) {
        Intrinsics.checkParameterIsNotNull((Object)description, (String)"description");
        Intrinsics.checkParameterIsNotNull((Object)spec, (String)"spec");
        TestListener.DefaultImpls.afterSpecCompleted((TestListener)this, (Description)description, (Spec)spec);
    }

    public void beforeProject() {
        TestListener.DefaultImpls.beforeProject((TestListener)this);
    }

    @Deprecated(replaceWith=@ReplaceWith(imports={}, expression="beforeSpec(Spec)"), message="use beforeSpec(Spec)")
    public void beforeSpec(@NotNull Description description, @NotNull Spec spec) {
        Intrinsics.checkParameterIsNotNull((Object)description, (String)"description");
        Intrinsics.checkParameterIsNotNull((Object)spec, (String)"spec");
        TestListener.DefaultImpls.beforeSpec((TestListener)this, (Description)description, (Spec)spec);
    }

    public void beforeSpec(@NotNull Spec spec) {
        Intrinsics.checkParameterIsNotNull((Object)spec, (String)"spec");
        TestListener.DefaultImpls.beforeSpec((TestListener)this, (Spec)spec);
    }

    public void beforeSpecClass(@NotNull Spec spec, @NotNull List<TopLevelTest> tests) {
        Intrinsics.checkParameterIsNotNull((Object)spec, (String)"spec");
        Intrinsics.checkParameterIsNotNull(tests, (String)"tests");
        TestListener.DefaultImpls.beforeSpecClass((TestListener)this, (Spec)spec, tests);
    }

    @Deprecated(replaceWith=@ReplaceWith(imports={}, expression="beforeSpecClass(Spec)"), message="use beforeSpecClass(Spec, List<TopLevelTest>)")
    public void beforeSpecStarted(@NotNull Description description, @NotNull Spec spec) {
        Intrinsics.checkParameterIsNotNull((Object)description, (String)"description");
        Intrinsics.checkParameterIsNotNull((Object)spec, (String)"spec");
        TestListener.DefaultImpls.beforeSpecStarted((TestListener)this, (Description)description, (Spec)spec);
    }

    @Deprecated(replaceWith=@ReplaceWith(imports={}, expression="beforeTest(TestCase)"), message="use beforeTest(TestCase) which provides the full test case instance")
    public void beforeTest(@NotNull Description description) {
        Intrinsics.checkParameterIsNotNull((Object)description, (String)"description");
        TestListener.DefaultImpls.beforeTest((TestListener)this, (Description)description);
    }

    public void beforeTest(@NotNull TestCase testCase) {
        Intrinsics.checkParameterIsNotNull((Object)testCase, (String)"testCase");
        TestListener.DefaultImpls.beforeTest((TestListener)this, (TestCase)testCase);
    }
}

