package io.kotlintest.datagen

data class StockExchange(val name: String, val symbol: String, val country: Country) {
  companion object {
    val exchanges = listOf(
        StockExchange("New York Stock Exchange", "NYSE", Country.US),
        StockExchange("NASDAQ Stock Exchange", "NASDAQ", Country.US),
        StockExchange("London Stock Exchange", "LSE", Country.UK),
        StockExchange("Tokyo Stock Exchange", "JPX", Country.Japan),
        StockExchange("Shanghai Stock Exchange", "SSE", Country.China),
        StockExchange("Hong Kong Stock Exchange", "HKEX", Country.HongKong),
        StockExchange("Euronext Amsterdam Stock Exchange", "Euronext", Country.Netherlands),
        StockExchange("Shenzhen Stock Exchange", "SZSE", Country.China),
        StockExchange("Toronto Stock Exchange", "TSX", Country.Canada),
        StockExchange("Bombay Stock Exchange", "BSE", Country.India),
        StockExchange("India National Stock Exchange", "NSE", Country.India),
        StockExchange("Swiss Stock Exchange", "SIX", Country.Switzerland),
        StockExchange("Australia Stock Exchange", "ASX", Country.Australia),
        StockExchange("South Korea Stock Exchange", "KRX", Country.SouthKorea),
        StockExchange("Stockholm Stock Exchange", "OMX", Country.Sweden),
        StockExchange("Johannesburg Stock Exchange", "JSE", Country.SouthAfrica),
        StockExchange("Spanish Stock Exchange", "BME", Country.Spain),
        StockExchange("Taiwan Stock Exchange", "TWSE", Country.Taiwan),
        StockExchange("Brazilian Stock Exchange", "Bovespa", Country.Brazil),
        StockExchange("German Stock Exchange", "FSX", Country.Germany),
        StockExchange("Malaysia Stock Exchange", "MYX", Country.Malaysia),
        StockExchange("Jamaica Stock Exchange", "JSE", Country.Jamaica),
        StockExchange("Chilean Stock Exchange", "BVS", Country.Chile),
        StockExchange("Colombia Stock Exchange", "BVC", Country.Colombia),
        StockExchange("Peruvian Stock Exchange", "BVL", Country.Peru),
        StockExchange("Mexican Stock Exchange", "BMV", Country.Mexico),
        StockExchange("Argentinian Stock Exchange", "BCBA", Country.Argentina),
        StockExchange("Chittagong Stock Exchange", "CSE", Country.Bangladesh),
        StockExchange("Colombo Stock Exchange", "CSE", Country.SriLanka),
        StockExchange("Dhaka Stock Exchange", "DSE", Country.Bangladesh),
        StockExchange("Ho Chi Minh Stock Exchange", "HOSE", Country.Vietnam),
        StockExchange("Indonesia Stock Exchange", "IDX", Country.Indonesia),
        StockExchange("New Zealand Stock Exchange", "NZX", Country.NewZealand),
        StockExchange("Philippine Stock Exchange", "PSE", Country.Philippines),
        StockExchange("Singapore Exchange", "SGX", Country.Singapore),
        StockExchange("Stock Exchange of Thailand", "SET", Country.Thailand),
        StockExchange("Abu Dhabi Stock Exchange", "ADX", Country.UAE),
        StockExchange("Amman Stock Exchange", "ASE", Country.Jordan),
        StockExchange("Athens Stock Exchange", "ASE", Country.Greece),
        StockExchange("Istanbul Stock Exchange", "BIST", Country.Turkey),
        StockExchange("Casablanca Stock Exchange", "BC", Country.Morocco),
        StockExchange("Bucharest Stock Exchange", "BVB", Country.Romania),
        StockExchange("Budapest Stock Exchange", "BSE", Country.Hungary),
        StockExchange("Dubai Financial Market", "DFM", Country.UAE),
        StockExchange("Egyptian Exchange", "EGX", Country.Egypt),
        StockExchange("Irish Stock Exchange", "ISE", Country.Ireland),
        StockExchange("Kazakhstan Stock Exchange", "KASE", Country.Kazakhstan),
        StockExchange("Luxembourg Stock Exchange", "LuxSE", Country.Luxembourg),
        StockExchange("Moscow Exchange", "MOEX", Country.Russia),
        StockExchange("Nigerian Stock Exchange", "NSE", Country.Nigeria),
        StockExchange("Oslo Stock Exchange", "OSE", Country.Norway),
        StockExchange("Palestine Securities Exchange", "PEX", Country.PalestinianTerritory),
        StockExchange("Qatar Stock Exchange", "QE", Country.Qatar),
        StockExchange("Saudi Stock Exchange", "Tadawul", Country.SaudiArabia),
        StockExchange("Stock Exchange of Mauritius", "SEM", Country.Mauritius),
        StockExchange("Tehran Stock Exchange", "TSE", Country.Iran),
        StockExchange("Tel-Aviv Stock Exchange", "TASE", Country.Israel),
        StockExchange("Ukrainian Exchange", "UX", Country.Ukraine),
        StockExchange("Warsaw Stock Exchange", "GPW", Country.Poland),
        StockExchange("Vienna Stock Exchange", "VSE", Country.Austria),
        StockExchange("Croatian Stock Exchange", "ZSE", Country.Croatia),
        StockExchange("Malta Stock Exchange", "MSE", Country.Malta),
        StockExchange("Barbados Stock Exchange", "BDE", Country.Barbados),
        StockExchange("Bermuda Stock Exchange", "BSX", Country.Bermuda),
        StockExchange("Hanoi Stock Exchange", "HNX", Country.Vietnam),
        StockExchange("Bahrain Stock Exchange", "BHB", Country.Bahrain),
        StockExchange("Beirut Stock Exchange", "BSE", Country.Lebanon),
        StockExchange("Eschborn Eurex Exchange", "EUREX", Country.Germany),
        StockExchange("Pakistan Stock Exchange", "PSX", Country.Pakistan),
        StockExchange("Nairobi Securities Exchange", "NSE", Country.Kenya),
        StockExchange("Helsinki Stock Exchange", "OMXH", Country.Finland),
        StockExchange("Riga Stock Exchange", "OMXR", Country.Latvia),
        StockExchange("Euronext Paris Stock Exchange", "Euronext", Country.France),
        StockExchange("BX Swiss", "BX", Country.Switzerland),
        StockExchange("Milan Stock Exchange", "MTA", Country.Italy),
        StockExchange("Copenhagen Stock Exchange", "OMXC", Country.Denmark),
        StockExchange("OTC Markets", "OTC", Country.US),
        StockExchange("NYSE American", "AMEX", Country.US),
        StockExchange("AIM Stock Exchange", "AIM", Country.US)
    )
  }
}

object StockExchangeProducer : Producer<StockExchange> {
  override fun produce(): StockExchange = StockExchange.exchanges.random()
}