package io.kotlintest.datagen

import com.univocity.parsers.csv.CsvParser
import com.univocity.parsers.csv.CsvParserSettings

data class Airport(val code: String, val name: String, val city: String, val country: Country) {
  companion object {
    val airports by lazy {
      val settings = CsvParserSettings()
      val parser = CsvParser(settings)
      parser.parseAll(this::class.java.getResourceAsStream("/airports.csv")).mapNotNull {
        try {
          Airport(it[3], it[0], it[2], Country.lookupByIsoAlpha2(it[1]))
        } catch (e: Exception) {
          null
        }
      }
    }
  }
}

object AirportProducer : Producer<Airport> {
  override fun produce(): Airport = Airport.airports.random()
}