/*
 * Decompiled with CFR 0.152.
 */
package io.kotest.framework.concurrency;

import io.kotest.common.ExperimentalKotest;
import io.kotest.framework.concurrency.EventuallyConfig;
import io.kotest.framework.concurrency.EventuallyControl;
import io.kotest.framework.concurrency.EventuallyShortCircuitException;
import io.kotest.framework.concurrency.EventuallyState;
import io.kotest.mpp.TimeInMillisKt;
import java.util.Collection;
import kotlin.ExceptionsKt;
import kotlin.Metadata;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.coroutines.jvm.internal.ContinuationImpl;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.reflect.KClass;
import kotlinx.coroutines.DelayKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\t\n\u0002\b\u0003\n\u0002\u0010\u0003\n\u0002\b\u000f\n\u0002\u0010\b\n\u0002\b\n\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0003\u0018\u00002\u00020\u0001B\u0011\u0012\n\u0010\u0002\u001a\u0006\u0012\u0002\b\u00030\u0003\u00a2\u0006\u0002\u0010\u0004J\u0006\u0010&\u001a\u00020'J\u0006\u0010(\u001a\u00020)J\u000e\u0010*\u001a\u00020'2\u0006\u0010+\u001a\u00020\fJ\u0006\u0010,\u001a\u00020'J\u0011\u0010-\u001a\u00020.H\u0086@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010/J!\u00100\u001a\b\u0012\u0004\u0012\u0002H201\"\u0004\b\u0000\u001022\b\u00103\u001a\u0004\u0018\u0001H2\u00a2\u0006\u0002\u00104R\u0015\u0010\u0002\u001a\u0006\u0012\u0002\b\u00030\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R\u0011\u0010\u0007\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u001c\u0010\u000b\u001a\u0004\u0018\u00010\fX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\r\u0010\u000e\"\u0004\b\u000f\u0010\u0010R\u001a\u0010\u0011\u001a\u00020\bX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0012\u0010\n\"\u0004\b\u0013\u0010\u0014R\u001c\u0010\u0015\u001a\u0004\u0018\u00010\fX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0016\u0010\u000e\"\u0004\b\u0017\u0010\u0010R\u001a\u0010\u0018\u001a\u00020\bX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0019\u0010\n\"\u0004\b\u001a\u0010\u0014R\u001a\u0010\u001b\u001a\u00020\u001cX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001d\u0010\u001e\"\u0004\b\u001f\u0010 R\u0011\u0010!\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\"\u0010\nR\u001a\u0010#\u001a\u00020\u001cX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b$\u0010\u001e\"\u0004\b%\u0010 \u0082\u0002\u0004\n\u0002\b\u0019\u00a8\u00065"}, d2={"Lio/kotest/framework/concurrency/EventuallyControl;", "", "config", "Lio/kotest/framework/concurrency/EventuallyConfig;", "(Lio/kotest/framework/concurrency/EventuallyConfig;)V", "getConfig", "()Lio/kotest/framework/concurrency/EventuallyConfig;", "end", "", "getEnd", "()J", "firstError", "", "getFirstError", "()Ljava/lang/Throwable;", "setFirstError", "(Ljava/lang/Throwable;)V", "lastDelayPeriod", "getLastDelayPeriod", "setLastDelayPeriod", "(J)V", "lastError", "getLastError", "setLastError", "lastInterval", "getLastInterval", "setLastInterval", "predicateFailedTimes", "", "getPredicateFailedTimes", "()I", "setPredicateFailedTimes", "(I)V", "start", "getStart", "times", "getTimes", "setTimes", "attemptsRemaining", "", "buildFailureMessage", "", "exceptionIsNotSuppressible", "e", "isLongWait", "step", "", "(Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "toState", "Lio/kotest/framework/concurrency/EventuallyState;", "T", "result", "(Ljava/lang/Object;)Lio/kotest/framework/concurrency/EventuallyState;", "kotest-framework-concurrency"})
@ExperimentalKotest
@SourceDebugExtension(value={"SMAP\neventually.kt\nKotlin\n*S Kotlin\n*F\n+ 1 eventually.kt\nio/kotest/framework/concurrency/EventuallyControl\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,249:1\n1747#2,3:250\n*S KotlinDebug\n*F\n+ 1 eventually.kt\nio/kotest/framework/concurrency/EventuallyControl\n*L\n103#1:250,3\n*E\n"})
final class EventuallyControl {
    @NotNull
    private final EventuallyConfig<?> config;
    private final long start;
    private final long end;
    private int times;
    private int predicateFailedTimes;
    @Nullable
    private Throwable firstError;
    @Nullable
    private Throwable lastError;
    private long lastDelayPeriod;
    private long lastInterval;

    public EventuallyControl(@NotNull EventuallyConfig<?> config) {
        Intrinsics.checkNotNullParameter(config, (String)"config");
        this.config = config;
        this.start = TimeInMillisKt.timeInMillis();
        this.end = this.start + this.config.getDuration();
    }

    @NotNull
    public final EventuallyConfig<?> getConfig() {
        return this.config;
    }

    public final long getStart() {
        return this.start;
    }

    public final long getEnd() {
        return this.end;
    }

    public final int getTimes() {
        return this.times;
    }

    public final void setTimes(int n) {
        this.times = n;
    }

    public final int getPredicateFailedTimes() {
        return this.predicateFailedTimes;
    }

    public final void setPredicateFailedTimes(int n) {
        this.predicateFailedTimes = n;
    }

    @Nullable
    public final Throwable getFirstError() {
        return this.firstError;
    }

    public final void setFirstError(@Nullable Throwable throwable) {
        this.firstError = throwable;
    }

    @Nullable
    public final Throwable getLastError() {
        return this.lastError;
    }

    public final void setLastError(@Nullable Throwable throwable) {
        this.lastError = throwable;
    }

    public final long getLastDelayPeriod() {
        return this.lastDelayPeriod;
    }

    public final void setLastDelayPeriod(long l) {
        this.lastDelayPeriod = l;
    }

    public final long getLastInterval() {
        return this.lastInterval;
    }

    public final void setLastInterval(long l) {
        this.lastInterval = l;
    }

    public final boolean exceptionIsNotSuppressible(@NotNull Throwable e) {
        boolean bl;
        block7: {
            Intrinsics.checkNotNullParameter((Object)e, (String)"e");
            if (this.firstError == null) {
                this.firstError = e;
            } else {
                this.lastError = e;
            }
            if (Reflection.getOrCreateKotlinClass(EventuallyShortCircuitException.class).isInstance((Object)e)) {
                return true;
            }
            Function1<Throwable, Boolean> function1 = this.config.getSuppressExceptionIf();
            boolean bl2 = function1 != null ? !((Boolean)function1.invoke((Object)e)).booleanValue() : false;
            if (bl2) {
                return true;
            }
            Iterable $this$any$iv = this.config.getSuppressExceptions();
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    KClass it = (KClass)element$iv;
                    boolean bl3 = false;
                    if (!it.isInstance((Object)e)) continue;
                    bl = true;
                    break block7;
                }
                bl = false;
            }
        }
        return !bl;
    }

    @NotNull
    public final <T> EventuallyState<T> toState(@Nullable T result) {
        return new EventuallyState<T>(result, this.start, this.end, this.times, this.firstError, this.lastError);
    }

    /*
     * Unable to fully structure code
     */
    @Nullable
    public final Object step(@NotNull Continuation<? super Unit> var1_1) {
        if (!(var1_1 instanceof step.1)) ** GOTO lbl-1000
        var5_2 = var1_1;
        if ((var5_2.label & -2147483648) != 0) {
            var5_2.label -= -2147483648;
        } else lbl-1000:
        // 2 sources

        {
            $continuation = new ContinuationImpl(this, var1_1){
                Object L$0;
                long J$0;
                /* synthetic */ Object result;
                final /* synthetic */ EventuallyControl this$0;
                int label;
                {
                    this.this$0 = this$0;
                    super($completion);
                }

                @Nullable
                public final Object invokeSuspend(@NotNull Object $result) {
                    this.result = $result;
                    this.label |= Integer.MIN_VALUE;
                    return this.this$0.step((Continuation<? super Unit>)((Continuation)this));
                }
            };
        }
        $result = $continuation.result;
        var6_4 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
        switch ($continuation.label) {
            case 0: {
                ResultKt.throwOnFailure((Object)$result);
                ++this.times;
                this.lastInterval = this.config.getInterval().next(this.times);
                delayMark = TimeInMillisKt.timeInMillis();
                $continuation.L$0 = this;
                $continuation.J$0 = delayMark;
                $continuation.label = 1;
                v0 = DelayKt.delay((long)this.lastInterval, (Continuation)$continuation);
                if (v0 == var6_4) {
                    return var6_4;
                }
                ** GOTO lbl27
            }
            case 1: {
                delayMark = $continuation.J$0;
                this = (EventuallyControl)$continuation.L$0;
                ResultKt.throwOnFailure((Object)$result);
                v0 = $result;
lbl27:
                // 2 sources

                this.lastDelayPeriod = TimeInMillisKt.timeInMillis() - delayMark;
                return Unit.INSTANCE;
            }
        }
        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
    }

    public final boolean attemptsRemaining() {
        return TimeInMillisKt.timeInMillis() < this.end && this.times < this.config.getRetries();
    }

    public final boolean isLongWait() {
        return this.times == 1 && this.lastDelayPeriod > this.lastInterval;
    }

    @NotNull
    public final String buildFailureMessage() {
        StringBuilder stringBuilder;
        StringBuilder stringBuilder2;
        StringBuilder $this$buildFailureMessage_u24lambda_u243 = stringBuilder2 = new StringBuilder();
        boolean bl = false;
        StringBuilder stringBuilder3 = $this$buildFailureMessage_u24lambda_u243.append("Eventually block failed after " + this.config.getDuration() + "ms; attempted " + this.times + " time(s); " + this.config.getInterval() + " delay between attempts");
        Intrinsics.checkNotNullExpressionValue((Object)stringBuilder3, (String)"append(value)");
        Intrinsics.checkNotNullExpressionValue((Object)stringBuilder3.append('\n'), (String)"append('\\n')");
        if (this.predicateFailedTimes > 0) {
            StringBuilder stringBuilder4 = $this$buildFailureMessage_u24lambda_u243.append("The provided predicate failed " + this.predicateFailedTimes + " times");
            Intrinsics.checkNotNullExpressionValue((Object)stringBuilder4, (String)"append(value)");
            Intrinsics.checkNotNullExpressionValue((Object)stringBuilder4.append('\n'), (String)"append('\\n')");
        }
        Throwable throwable = this.firstError;
        if (throwable != null) {
            Throwable $this$buildFailureMessage_u24lambda_u243_u24lambda_u241 = throwable;
            boolean bl2 = false;
            StringBuilder stringBuilder5 = $this$buildFailureMessage_u24lambda_u243.append("The first error was caused by: " + $this$buildFailureMessage_u24lambda_u243_u24lambda_u241.getMessage());
            Intrinsics.checkNotNullExpressionValue((Object)stringBuilder5, (String)"append(value)");
            Intrinsics.checkNotNullExpressionValue((Object)stringBuilder5.append('\n'), (String)"append('\\n')");
            StringBuilder stringBuilder6 = $this$buildFailureMessage_u24lambda_u243.append(ExceptionsKt.stackTraceToString((Throwable)$this$buildFailureMessage_u24lambda_u243_u24lambda_u241));
            Intrinsics.checkNotNullExpressionValue((Object)stringBuilder6, (String)"append(value)");
            StringBuilder stringBuilder7 = stringBuilder6.append('\n');
            stringBuilder = stringBuilder7;
            Intrinsics.checkNotNullExpressionValue((Object)stringBuilder7, (String)"append('\\n')");
        } else {
            stringBuilder = null;
        }
        Throwable throwable2 = this.lastError;
        if (throwable2 != null) {
            Throwable $this$buildFailureMessage_u24lambda_u243_u24lambda_u242 = throwable2;
            boolean bl3 = false;
            StringBuilder stringBuilder8 = $this$buildFailureMessage_u24lambda_u243.append("The last error was caused by: " + $this$buildFailureMessage_u24lambda_u243_u24lambda_u242.getMessage());
            Intrinsics.checkNotNullExpressionValue((Object)stringBuilder8, (String)"append(value)");
            Intrinsics.checkNotNullExpressionValue((Object)stringBuilder8.append('\n'), (String)"append('\\n')");
            StringBuilder stringBuilder9 = $this$buildFailureMessage_u24lambda_u243.append(ExceptionsKt.stackTraceToString((Throwable)$this$buildFailureMessage_u24lambda_u243_u24lambda_u242));
            Intrinsics.checkNotNullExpressionValue((Object)stringBuilder9, (String)"append(value)");
            Intrinsics.checkNotNullExpressionValue((Object)stringBuilder9.append('\n'), (String)"append('\\n')");
        }
        String string = stringBuilder2.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"StringBuilder().apply {\n\u2026)\n      }\n   }.toString()");
        return string;
    }
}

