/*
 * Decompiled with CFR 0.152.
 */
package org.json.zip;

import org.json.JSONException;
import org.json.zip.BitReader;
import org.json.zip.BitWriter;
import org.json.zip.Huff$Symbol;
import org.json.zip.JSONzip;
import org.json.zip.None;
import org.json.zip.PostMortem;

public class Huff
implements None,
PostMortem {
    private final int domain;
    private final Huff$Symbol[] symbols;
    private Huff$Symbol table;
    private boolean upToDate = false;
    private int width;

    public Huff(int domain) {
        int n;
        this.domain = domain;
        int n2 = domain * 2 - 1;
        this.symbols = new Huff$Symbol[n2];
        for (n = 0; n < domain; ++n) {
            this.symbols[n] = new Huff$Symbol(n);
        }
        for (n = domain; n < n2; ++n) {
            this.symbols[n] = new Huff$Symbol(-1);
        }
    }

    public void generate() {
        if (!this.upToDate) {
            Huff$Symbol huff$Symbol;
            Huff$Symbol huff$Symbol2;
            int n;
            Huff$Symbol huff$Symbol3;
            Huff$Symbol huff$Symbol4 = huff$Symbol3 = this.symbols[0];
            this.table = null;
            huff$Symbol3.next = null;
            for (n = 1; n < this.domain; ++n) {
                huff$Symbol2 = this.symbols[n];
                if (huff$Symbol2.weight < huff$Symbol3.weight) {
                    huff$Symbol2.next = huff$Symbol3;
                    huff$Symbol3 = huff$Symbol2;
                    continue;
                }
                if (huff$Symbol2.weight < huff$Symbol4.weight) {
                    huff$Symbol4 = huff$Symbol3;
                }
                while ((huff$Symbol = huff$Symbol4.next) != null && huff$Symbol2.weight >= huff$Symbol.weight) {
                    huff$Symbol4 = huff$Symbol;
                }
                huff$Symbol2.next = huff$Symbol;
                huff$Symbol4.next = huff$Symbol2;
                huff$Symbol4 = huff$Symbol2;
            }
            n = this.domain;
            huff$Symbol4 = huff$Symbol3;
            while (true) {
                Huff$Symbol huff$Symbol5 = huff$Symbol3;
                Huff$Symbol huff$Symbol6 = huff$Symbol5.next;
                huff$Symbol3 = huff$Symbol6.next;
                huff$Symbol2 = this.symbols[n];
                ++n;
                huff$Symbol2.weight = huff$Symbol5.weight + huff$Symbol6.weight;
                huff$Symbol2.zero = huff$Symbol5;
                huff$Symbol2.one = huff$Symbol6;
                huff$Symbol2.back = null;
                huff$Symbol5.back = huff$Symbol2;
                huff$Symbol6.back = huff$Symbol2;
                if (huff$Symbol3 == null) break;
                if (huff$Symbol2.weight < huff$Symbol3.weight) {
                    huff$Symbol2.next = huff$Symbol3;
                    huff$Symbol4 = huff$Symbol3 = huff$Symbol2;
                    continue;
                }
                while ((huff$Symbol = huff$Symbol4.next) != null && huff$Symbol2.weight >= huff$Symbol.weight) {
                    huff$Symbol4 = huff$Symbol;
                }
                huff$Symbol2.next = huff$Symbol;
                huff$Symbol4.next = huff$Symbol2;
                huff$Symbol4 = huff$Symbol2;
            }
            this.table = huff$Symbol2;
            this.upToDate = true;
        }
    }

    private boolean postMortem(int integer) {
        Huff$Symbol huff$Symbol;
        int[] nArray = new int[this.domain];
        Huff$Symbol huff$Symbol2 = this.symbols[integer];
        if (huff$Symbol2.integer != integer) {
            return false;
        }
        int n = 0;
        while ((huff$Symbol = huff$Symbol2.back) != null) {
            if (huff$Symbol.zero == huff$Symbol2) {
                nArray[n] = 0;
            } else if (huff$Symbol.one == huff$Symbol2) {
                nArray[n] = 1;
            } else {
                return false;
            }
            ++n;
            huff$Symbol2 = huff$Symbol;
        }
        if (huff$Symbol2 != this.table) {
            return false;
        }
        this.width = 0;
        huff$Symbol2 = this.table;
        while (huff$Symbol2.integer == -1) {
            huff$Symbol2 = nArray[--n] != 0 ? huff$Symbol2.one : huff$Symbol2.zero;
        }
        return huff$Symbol2.integer == integer && n == 0;
    }

    public boolean postMortem(PostMortem pm) {
        for (int i = 0; i < this.domain; ++i) {
            if (this.postMortem(i)) continue;
            JSONzip.log("\nBad huff ");
            JSONzip.logchar(i, i);
            return false;
        }
        return this.table.postMortem(((Huff)pm).table);
    }

    public int read(BitReader bitreader) throws JSONException {
        try {
            this.width = 0;
            Huff$Symbol huff$Symbol = this.table;
            while (huff$Symbol.integer == -1) {
                ++this.width;
                huff$Symbol = bitreader.bit() ? huff$Symbol.one : huff$Symbol.zero;
            }
            this.tick(huff$Symbol.integer);
            return huff$Symbol.integer;
        }
        catch (Throwable throwable) {
            throw new JSONException(throwable);
        }
    }

    public void tick(int value) {
        ++this.symbols[value].weight;
        this.upToDate = false;
    }

    public void tick(int from, int to) {
        for (int i = from; i <= to; ++i) {
            this.tick(i);
        }
    }

    private void write(Huff$Symbol symbol, BitWriter bitwriter) throws JSONException {
        try {
            Huff$Symbol huff$Symbol = symbol.back;
            if (huff$Symbol != null) {
                ++this.width;
                this.write(huff$Symbol, bitwriter);
                if (huff$Symbol.zero == symbol) {
                    bitwriter.zero();
                } else {
                    bitwriter.one();
                }
            }
        }
        catch (Throwable throwable) {
            throw new JSONException(throwable);
        }
    }

    public void write(int value, BitWriter bitwriter) throws JSONException {
        this.width = 0;
        this.write(this.symbols[value], bitwriter);
        this.tick(value);
    }
}

