/*
 * Decompiled with CFR 0.152.
 */
package org.json.zip;

import java.io.UnsupportedEncodingException;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;
import org.json.Kim;
import org.json.zip.BitReader;
import org.json.zip.JSONzip;
import org.json.zip.Keep;

public class Decompressor
extends JSONzip {
    BitReader bitreader;

    public Decompressor(BitReader bitreader) {
        this.bitreader = bitreader;
    }

    private boolean bit() throws JSONException {
        try {
            boolean bl = this.bitreader.bit();
            return bl;
        }
        catch (Throwable throwable) {
            throw new JSONException(throwable);
        }
    }

    private Object getAndTick(Keep keep, BitReader bitreader) throws JSONException {
        try {
            int n = keep.bitsize();
            int n2 = bitreader.read(n);
            Object object = keep.value(n2);
            if (n2 >= keep.length) {
                throw new JSONException("Deep error.");
            }
            keep.tick(n2);
            return object;
        }
        catch (Throwable throwable) {
            throw new JSONException(throwable);
        }
    }

    public boolean pad(int factor) throws JSONException {
        try {
            return this.bitreader.pad(factor);
        }
        catch (Throwable throwable) {
            throw new JSONException(throwable);
        }
    }

    private int read(int width) throws JSONException {
        try {
            int n = this.bitreader.read(width);
            return n;
        }
        catch (Throwable throwable) {
            throw new JSONException(throwable);
        }
    }

    private JSONArray readArray(boolean stringy) throws JSONException {
        JSONArray jSONArray = new JSONArray();
        jSONArray.put(stringy ? this.readString() : this.readValue());
        while (true) {
            if (!this.bit()) {
                if (!this.bit()) {
                    return jSONArray;
                }
                jSONArray.put(stringy ? this.readValue() : this.readString());
                continue;
            }
            jSONArray.put(stringy ? this.readString() : this.readValue());
        }
    }

    private Object readJSON() throws JSONException {
        switch (this.read(3)) {
            case 5: {
                return this.readObject();
            }
            case 6: {
                return this.readArray(true);
            }
            case 7: {
                return this.readArray(false);
            }
            case 0: {
                return new JSONObject();
            }
            case 1: {
                return new JSONArray();
            }
            case 2: {
                return Boolean.TRUE;
            }
            case 3: {
                return Boolean.FALSE;
            }
        }
        return JSONObject.NULL;
    }

    private String readName() throws JSONException {
        byte[] byArray = new byte[65536];
        int n = 0;
        if (!this.bit()) {
            int n2;
            while ((n2 = this.namehuff.read(this.bitreader)) != 256) {
                byArray[n] = (byte)n2;
                ++n;
            }
            if (n == 0) {
                return "";
            }
            Kim kim = new Kim(byArray, n);
            this.namekeep.register(kim);
            return kim.toString();
        }
        return this.getAndTick(this.namekeep, this.bitreader).toString();
    }

    private JSONObject readObject() throws JSONException {
        JSONObject jSONObject = new JSONObject();
        do {
            String string = this.readName();
            jSONObject.put(string, !this.bit() ? this.readString() : this.readValue());
        } while (this.bit());
        return jSONObject;
    }

    private String readString() throws JSONException {
        Kim kim;
        int n = 0;
        int n2 = 0;
        int n3 = -1;
        int n4 = 0;
        if (this.bit()) {
            return this.getAndTick(this.stringkeep, this.bitreader).toString();
        }
        byte[] byArray = new byte[65536];
        boolean bl = this.bit();
        this.substringkeep.reserve();
        while (true) {
            int n5;
            if (bl) {
                n = n2;
                kim = (Kim)this.getAndTick(this.substringkeep, this.bitreader);
                n2 = kim.copy(byArray, n);
                if (n3 != -1) {
                    this.substringkeep.registerOne(new Kim(byArray, n3, n4 + 1));
                }
                n3 = n;
                n4 = n2;
                bl = this.bit();
                continue;
            }
            n = -1;
            while ((n5 = this.substringhuff.read(this.bitreader)) != 256) {
                byArray[n2] = (byte)n5;
                ++n2;
                if (n3 == -1) continue;
                this.substringkeep.registerOne(new Kim(byArray, n3, n4 + 1));
                n3 = -1;
            }
            if (!this.bit()) break;
            bl = true;
        }
        if (n2 == 0) {
            return "";
        }
        kim = new Kim(byArray, n2);
        this.stringkeep.register(kim);
        this.substringkeep.registerMany(kim);
        return kim.toString();
    }

    private Object readValue() throws JSONException {
        switch (this.read(2)) {
            case 0: {
                return new Integer(this.read(!this.bit() ? 4 : (!this.bit() ? 7 : 14)));
            }
            case 1: {
                Object object;
                int n;
                byte[] byArray = new byte[256];
                int n2 = 0;
                while ((n = this.read(4)) != endOfNumber) {
                    byArray[n2] = bcd[n];
                    ++n2;
                }
                try {
                    object = JSONObject.stringToValue(new String(byArray, 0, n2, "US-ASCII"));
                }
                catch (UnsupportedEncodingException unsupportedEncodingException) {
                    throw new JSONException(unsupportedEncodingException);
                }
                this.values.register(object);
                return object;
            }
            case 2: {
                return this.getAndTick(this.values, this.bitreader);
            }
            case 3: {
                return this.readJSON();
            }
        }
        throw new JSONException("Impossible.");
    }

    public Object unzip() throws JSONException {
        this.begin();
        return this.readJSON();
    }
}

