/*
 * Decompiled with CFR 0.152.
 */
package org.json;

import java.util.Iterator;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;
import org.json.XMLTokener;

public class XML {
    public static final Character AMP = new Character('&');
    public static final Character APOS = new Character('\'');
    public static final Character BANG = new Character('!');
    public static final Character EQ = new Character('=');
    public static final Character GT = new Character('>');
    public static final Character LT = new Character('<');
    public static final Character QUEST = new Character('?');
    public static final Character QUOT = new Character('\"');
    public static final Character SLASH = new Character('/');

    public static String escape(String string) {
        StringBuffer stringBuffer = new StringBuffer();
        int n = string.length();
        block7: for (int i = 0; i < n; ++i) {
            char c = string.charAt(i);
            switch (c) {
                case '&': {
                    stringBuffer.append("&amp;");
                    continue block7;
                }
                case '<': {
                    stringBuffer.append("&lt;");
                    continue block7;
                }
                case '>': {
                    stringBuffer.append("&gt;");
                    continue block7;
                }
                case '\"': {
                    stringBuffer.append("&quot;");
                    continue block7;
                }
                case '\'': {
                    stringBuffer.append("&apos;");
                    continue block7;
                }
                default: {
                    stringBuffer.append(c);
                }
            }
        }
        return stringBuffer.toString();
    }

    public static void noSpace(String string) throws JSONException {
        int n = string.length();
        if (n == 0) {
            throw new JSONException("Empty string.");
        }
        for (int i = 0; i < n; ++i) {
            if (!Character.isWhitespace(string.charAt(i))) continue;
            throw new JSONException("'" + string + "' contains a space character.");
        }
    }

    private static boolean parse(XMLTokener x, JSONObject context, String name) throws JSONException {
        String string;
        JSONObject jSONObject = null;
        Object object = x.nextToken();
        if (object == BANG) {
            char c = x.next();
            if (c == '-') {
                if (x.next() == '-') {
                    x.skipPast("-->");
                    return false;
                }
                x.back();
            } else if (c == '[') {
                object = x.nextToken();
                if ("CDATA".equals(object) && x.next() == '[') {
                    String string2 = x.nextCDATA();
                    if (string2.length() > 0) {
                        context.accumulate("content", string2);
                    }
                    return false;
                }
                throw x.syntaxError("Expected 'CDATA['");
            }
            int n = 1;
            do {
                if ((object = x.nextMeta()) == null) {
                    throw x.syntaxError("Missing '>' after '<!'.");
                }
                if (object == LT) {
                    ++n;
                    continue;
                }
                if (object != GT) continue;
                --n;
            } while (n > 0);
            return false;
        }
        if (object == QUEST) {
            x.skipPast("?>");
            return false;
        }
        if (object == SLASH) {
            object = x.nextToken();
            if (name == null) {
                throw x.syntaxError("Mismatched close tag " + object);
            }
            if (!object.equals(name)) {
                throw x.syntaxError("Mismatched " + name + " and " + object);
            }
            if (x.nextToken() != GT) {
                throw x.syntaxError("Misshaped close tag");
            }
            return true;
        }
        if (object instanceof Character) {
            throw x.syntaxError("Misshaped tag");
        }
        String string3 = (String)object;
        object = null;
        jSONObject = new JSONObject();
        while (true) {
            if (object == null) {
                object = x.nextToken();
            }
            if (!(object instanceof String)) break;
            string = (String)object;
            object = x.nextToken();
            if (object == EQ) {
                object = x.nextToken();
                if (!(object instanceof String)) {
                    throw x.syntaxError("Missing value");
                }
                jSONObject.accumulate(string, XML.stringToValue((String)object));
                object = null;
                continue;
            }
            jSONObject.accumulate(string, "");
        }
        if (object == SLASH) {
            if (x.nextToken() != GT) {
                throw x.syntaxError("Misshaped tag");
            }
            if (jSONObject.length() > 0) {
                context.accumulate(string3, jSONObject);
            } else {
                context.accumulate(string3, "");
            }
            return false;
        }
        if (object == GT) {
            while (true) {
                if ((object = x.nextContent()) == null) {
                    if (string3 != null) {
                        throw x.syntaxError("Unclosed tag " + string3);
                    }
                    return false;
                }
                if (object instanceof String) {
                    string = (String)object;
                    if (string.length() <= 0) continue;
                    jSONObject.accumulate("content", XML.stringToValue(string));
                    continue;
                }
                if (object == LT && XML.parse(x, jSONObject, string3)) break;
            }
            if (jSONObject.length() == 0) {
                context.accumulate(string3, "");
            } else if (jSONObject.length() == 1 && jSONObject.opt("content") != null) {
                context.accumulate(string3, jSONObject.opt("content"));
            } else {
                context.accumulate(string3, jSONObject);
            }
            return false;
        }
        throw x.syntaxError("Misshaped tag");
    }

    public static Object stringToValue(String string) {
        if ("true".equalsIgnoreCase(string)) {
            return Boolean.TRUE;
        }
        if ("false".equalsIgnoreCase(string)) {
            return Boolean.FALSE;
        }
        if ("null".equalsIgnoreCase(string)) {
            return JSONObject.NULL;
        }
        try {
            Long l;
            char c = string.charAt(0);
            if ((c == '-' || c >= '0' && c <= '9') && (l = new Long(string)).toString().equals(string)) {
                return l;
            }
        }
        catch (Exception exception) {
            try {
                Double d = new Double(string);
                if (d.toString().equals(string)) {
                    return d;
                }
            }
            catch (Exception exception2) {
                // empty catch block
            }
        }
        return string;
    }

    public static JSONObject toJSONObject(String string) throws JSONException {
        JSONObject jSONObject = new JSONObject();
        XMLTokener xMLTokener = new XMLTokener(string);
        while (xMLTokener.more() && xMLTokener.skipPast("<")) {
            XML.parse(xMLTokener, jSONObject, null);
        }
        return jSONObject;
    }

    public static String toString(Object object) throws JSONException {
        return XML.toString(object, null);
    }

    public static String toString(Object object, String tagName) throws JSONException {
        String string;
        StringBuffer stringBuffer = new StringBuffer();
        if (object instanceof JSONObject) {
            if (tagName != null) {
                stringBuffer.append('<');
                stringBuffer.append(tagName);
                stringBuffer.append('>');
            }
            JSONObject jSONObject = (JSONObject)object;
            Iterator iterator = jSONObject.keys();
            while (iterator.hasNext()) {
                int n;
                int n2;
                JSONArray jSONArray;
                String string2 = iterator.next().toString();
                Object object2 = jSONObject.opt(string2);
                if (object2 == null) {
                    object2 = "";
                }
                String string3 = object2 instanceof String ? (String)object2 : null;
                if ("content".equals(string2)) {
                    if (object2 instanceof JSONArray) {
                        jSONArray = (JSONArray)object2;
                        n2 = jSONArray.length();
                        for (n = 0; n < n2; ++n) {
                            if (n > 0) {
                                stringBuffer.append('\n');
                            }
                            stringBuffer.append(XML.escape(jSONArray.get(n).toString()));
                        }
                        continue;
                    }
                    stringBuffer.append(XML.escape(object2.toString()));
                    continue;
                }
                if (object2 instanceof JSONArray) {
                    jSONArray = (JSONArray)object2;
                    n2 = jSONArray.length();
                    for (n = 0; n < n2; ++n) {
                        object2 = jSONArray.get(n);
                        if (object2 instanceof JSONArray) {
                            stringBuffer.append('<');
                            stringBuffer.append(string2);
                            stringBuffer.append('>');
                            stringBuffer.append(XML.toString(object2));
                            stringBuffer.append("</");
                            stringBuffer.append(string2);
                            stringBuffer.append('>');
                            continue;
                        }
                        stringBuffer.append(XML.toString(object2, string2));
                    }
                    continue;
                }
                if ("".equals(object2)) {
                    stringBuffer.append('<');
                    stringBuffer.append(string2);
                    stringBuffer.append("/>");
                    continue;
                }
                stringBuffer.append(XML.toString(object2, string2));
            }
            if (tagName != null) {
                stringBuffer.append("</");
                stringBuffer.append(tagName);
                stringBuffer.append('>');
            }
            return stringBuffer.toString();
        }
        if (object.getClass().isArray()) {
            object = new JSONArray(object);
        }
        if (object instanceof JSONArray) {
            JSONArray jSONArray = (JSONArray)object;
            int n = jSONArray.length();
            for (int i = 0; i < n; ++i) {
                stringBuffer.append(XML.toString(jSONArray.opt(i), tagName == null ? "array" : tagName));
            }
            return stringBuffer.toString();
        }
        String string4 = string = object == null ? "null" : XML.escape(object.toString());
        return tagName == null ? "\"" + string + "\"" : (string.length() == 0 ? "<" + tagName + "/>" : "<" + tagName + ">" + string + "</" + tagName + ">");
    }
}

