/*
 * Decompiled with CFR 0.152.
 */
package org.json;

import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;
import org.json.JSONTokener;

public class CDL {
    private static String getValue(JSONTokener x) throws JSONException {
        char c;
        while ((c = x.next()) == ' ' || c == '\t') {
        }
        switch (c) {
            case '\u0000': {
                return null;
            }
            case '\"': 
            case '\'': {
                char c2 = c;
                StringBuffer stringBuffer = new StringBuffer();
                while ((c = x.next()) != c2) {
                    if (c == '\u0000' || c == '\n' || c == '\r') {
                        throw x.syntaxError("Missing close quote '" + c2 + "'.");
                    }
                    stringBuffer.append(c);
                }
                return stringBuffer.toString();
            }
            case ',': {
                x.back();
                return "";
            }
        }
        x.back();
        return x.nextTo(',');
    }

    public static JSONArray rowToJSONArray(JSONTokener x) throws JSONException {
        JSONArray jSONArray = new JSONArray();
        block0: while (true) {
            String string = CDL.getValue(x);
            char c = x.next();
            if (string == null || jSONArray.length() == 0 && string.length() == 0 && c != ',') {
                return null;
            }
            jSONArray.put(string);
            while (true) {
                if (c == ',') continue block0;
                if (c != ' ') {
                    if (c == '\n' || c == '\r' || c == '\u0000') {
                        return jSONArray;
                    }
                    throw x.syntaxError("Bad character '" + c + "' (" + c + ").");
                }
                c = x.next();
            }
            break;
        }
    }

    public static JSONObject rowToJSONObject(JSONArray names, JSONTokener x) throws JSONException {
        JSONArray jSONArray = CDL.rowToJSONArray(x);
        return jSONArray != null ? jSONArray.toJSONObject(names) : null;
    }

    public static String rowToString(JSONArray ja) {
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < ja.length(); ++i) {
            Object object;
            if (i > 0) {
                stringBuffer.append(',');
            }
            if ((object = ja.opt(i)) == null) continue;
            String string = object.toString();
            if (string.length() > 0 && (string.indexOf(44) >= 0 || string.indexOf(10) >= 0 || string.indexOf(13) >= 0 || string.indexOf(0) >= 0 || string.charAt(0) == '\"')) {
                stringBuffer.append('\"');
                int n = string.length();
                for (int j = 0; j < n; ++j) {
                    char c = string.charAt(j);
                    if (c < ' ' || c == '\"') continue;
                    stringBuffer.append(c);
                }
                stringBuffer.append('\"');
                continue;
            }
            stringBuffer.append(string);
        }
        stringBuffer.append('\n');
        return stringBuffer.toString();
    }

    public static JSONArray toJSONArray(String string) throws JSONException {
        return CDL.toJSONArray(new JSONTokener(string));
    }

    public static JSONArray toJSONArray(JSONTokener x) throws JSONException {
        return CDL.toJSONArray(CDL.rowToJSONArray(x), x);
    }

    public static JSONArray toJSONArray(JSONArray names, String string) throws JSONException {
        return CDL.toJSONArray(names, new JSONTokener(string));
    }

    public static JSONArray toJSONArray(JSONArray names, JSONTokener x) throws JSONException {
        JSONObject jSONObject;
        if (names == null || names.length() == 0) {
            return null;
        }
        JSONArray jSONArray = new JSONArray();
        while ((jSONObject = CDL.rowToJSONObject(names, x)) != null) {
            jSONArray.put(jSONObject);
        }
        if (jSONArray.length() == 0) {
            return null;
        }
        return jSONArray;
    }

    public static String toString(JSONArray ja) throws JSONException {
        JSONArray jSONArray;
        JSONObject jSONObject = ja.optJSONObject(0);
        if (jSONObject != null && (jSONArray = jSONObject.names()) != null) {
            return CDL.rowToString(jSONArray) + CDL.toString(jSONArray, ja);
        }
        return null;
    }

    public static String toString(JSONArray names, JSONArray ja) throws JSONException {
        if (names == null || names.length() == 0) {
            return null;
        }
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < ja.length(); ++i) {
            JSONObject jSONObject = ja.optJSONObject(i);
            if (jSONObject == null) continue;
            stringBuffer.append(CDL.rowToString(jSONObject.toJSONArray(names)));
        }
        return stringBuffer.toString();
    }
}

