/*
 * Decompiled with CFR 0.152.
 */
package io.konverge.library;

import io.konverge.library.Utility;
import java.io.OutputStreamWriter;
import java.io.UnsupportedEncodingException;
import java.net.URL;
import java.net.URLConnection;
import java.net.URLEncoder;
import java.util.HashMap;
import java.util.Random;

final class Request {
    protected static Random s_random = new Random();
    protected String m_address = "";
    private final HashMap<String, String> m_parameters = new HashMap();
    protected String m_response = "";
    protected int m_statusCode = 0;

    public static final String encode(String value) {
        try {
            return URLEncoder.encode(value, "UTF-8");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            return "";
        }
    }

    protected Request(String address) {
        String string = address.substring(0, address.lastIndexOf("/"));
        String string2 = address.substring(address.lastIndexOf("/") + 1);
        this.m_address = string + "/" + Request.encode(string2).replace("+", "%20");
    }

    public Request execute() {
        this.setParameter("_random_", "" + s_random.nextLong());
        try {
            URL uRL = new URL(this.m_address);
            URLConnection uRLConnection = uRL.openConnection();
            uRLConnection.setDoOutput(true);
            OutputStreamWriter outputStreamWriter = new OutputStreamWriter(uRLConnection.getOutputStream());
            outputStreamWriter.write(Utility.join(this.m_parameters, "=", "&"));
            outputStreamWriter.flush();
            this.m_response = Utility.toString(uRLConnection.getInputStream());
            this.m_statusCode = 200;
            outputStreamWriter.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
        return this;
    }

    public String getResponse() {
        return this.m_response;
    }

    public int getStatusCode() {
        return this.m_statusCode;
    }

    public Request setParameter(String name, double value) {
        this.setParameter(name, "" + value);
        return this;
    }

    public Request setParameter(String name, long value) {
        this.setParameter(name, "" + value);
        return this;
    }

    public Request setParameter(String name, String value) {
        this.m_parameters.put(Request.encode(name), value != null ? Request.encode(value) : "");
        return this;
    }
}

