/*
 * Decompiled with CFR 0.152.
 */
package io.konverge.library;

import io.konverge.library.Agent;
import io.konverge.library.ExceptionHandler;
import io.konverge.library.IExtra;
import io.konverge.library.Konverge$1;
import io.konverge.library.Request;
import io.konverge.library.Utility;
import java.io.File;
import java.io.FileInputStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.net.URLDecoder;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import org.json.JSONObject;

public final class Konverge
implements Runnable {
    private static String s_apiKey;
    private static boolean s_debugEnabled;
    private static List<IExtra> s_extra;
    private static boolean s_initialized;
    private static boolean s_localLogEnabled;
    private static String s_protocol;
    private static String s_server;
    private static boolean s_textStackEnabled;
    private static String s_version;
    public static final String TYPE_ASSERT = "Assert";
    public static final String TYPE_CRITICAL = "Critical";
    public static final String TYPE_DEBUG = "Debug";
    public static final String TYPE_ERROR = "Error";
    public static final String TYPE_EXCEPTION = "Exception";
    public static final String TYPE_FATAL = "Fatal";
    public static final String TYPE_FEEDBACK = "Feedback";
    public static final String TYPE_INFO = "Info";
    public static final String TYPE_UNCAUGHT = "Uncaught";
    public static final String TYPE_WARNING = "Warning";
    private JSONObject m_extra = null;
    private String m_opaque = null;
    private String m_stack = null;
    private String m_text = null;
    private String m_type = null;

    public static void addExtra(IExtra extra) {
        s_extra.add(extra);
    }

    public static void assertion(boolean condition, String text) {
        if (condition) {
            return;
        }
        if (!s_initialized) {
            return;
        }
        String string = Konverge.callStack(text);
        Konverge.process(TYPE_ASSERT, s_textStackEnabled ? string : text, string, (String)null);
    }

    public static void assertion(boolean condition, String text, JSONObject opaque) {
        if (condition) {
            return;
        }
        if (!s_initialized) {
            return;
        }
        String string = Konverge.callStack(text);
        Konverge.process(TYPE_ASSERT, s_textStackEnabled ? string : text, string, opaque);
    }

    public static void assertion(String text) {
        if (!s_initialized) {
            return;
        }
        String string = Konverge.callStack(text);
        Konverge.process(TYPE_ASSERT, s_textStackEnabled ? string : text, string, (String)null);
    }

    public static void assertion(String text, JSONObject opaque) {
        if (!s_initialized) {
            return;
        }
        String string = Konverge.callStack(text);
        Konverge.process(TYPE_ASSERT, s_textStackEnabled ? string : text, string, opaque);
    }

    private static String callStack(String text) {
        StringWriter stringWriter = new StringWriter();
        new Exception().printStackTrace(new PrintWriter(stringWriter));
        ArrayList<String> arrayList = new ArrayList<String>(Arrays.asList(stringWriter.toString().split("\n")));
        arrayList.set(0, text);
        arrayList.remove(1);
        arrayList.remove(1);
        return Utility.join(arrayList, "\n");
    }

    public static void capture(String type, String text) {
        if (!s_initialized) {
            return;
        }
        String string = Konverge.callStack(text);
        Konverge.process(type, s_textStackEnabled ? string : text, string, (String)null);
    }

    public static void capture(String type, String text, JSONObject opaque) {
        if (!s_initialized) {
            return;
        }
        String string = Konverge.callStack(text);
        Konverge.process(type, s_textStackEnabled ? string : text, string, opaque);
    }

    public static void capture(String type, String text, String opaque) {
        if (!s_initialized) {
            return;
        }
        String string = Konverge.callStack(text);
        Konverge.process(type, s_textStackEnabled ? string : text, string, opaque);
    }

    public static void capture(String type, Throwable throwable) {
        if (!s_initialized) {
            return;
        }
        Konverge.preprocess(type, throwable, (String)null);
    }

    public static void capture(String type, Throwable throwable, JSONObject opaque) {
        if (!s_initialized) {
            return;
        }
        Konverge.preprocess(type, throwable, opaque);
    }

    public static void capture(String type, Throwable throwable, String opaque) {
        if (!s_initialized) {
            return;
        }
        Konverge.preprocess(type, throwable, opaque);
    }

    protected static void capture(Throwable throwable) {
        if (!s_initialized) {
            return;
        }
        Konverge.preprocess(TYPE_EXCEPTION, throwable, (String)null);
    }

    public static void critical(Exception exception) {
        if (!s_initialized) {
            return;
        }
        Konverge.preprocess(TYPE_CRITICAL, (Throwable)exception, (String)null);
    }

    public static void critical(Exception exception, JSONObject opaque) {
        if (!s_initialized) {
            return;
        }
        Konverge.preprocess(TYPE_CRITICAL, (Throwable)exception, opaque);
    }

    public static void critical(String text) {
        if (!s_initialized) {
            return;
        }
        String string = Konverge.callStack(text);
        Konverge.process(TYPE_CRITICAL, s_textStackEnabled ? string : text, string, (String)null);
    }

    public static void critical(String text, JSONObject opaque) {
        if (!s_initialized) {
            return;
        }
        String string = Konverge.callStack(text);
        Konverge.process(TYPE_CRITICAL, s_textStackEnabled ? string : text, string, opaque);
    }

    public static void debug(Exception exception) {
        if (!s_initialized) {
            return;
        }
        Konverge.preprocess(TYPE_DEBUG, (Throwable)exception, (String)null);
    }

    public static void debug(Exception exception, JSONObject opaque) {
        if (!s_initialized) {
            return;
        }
        Konverge.preprocess(TYPE_DEBUG, (Throwable)exception, opaque);
    }

    public static void debug(String text) {
        if (!s_initialized) {
            return;
        }
        String string = Konverge.callStack(text);
        Konverge.process(TYPE_DEBUG, s_textStackEnabled ? string : text, string, (String)null);
    }

    public static void debug(String text, JSONObject opaque) {
        if (!s_initialized) {
            return;
        }
        String string = Konverge.callStack(text);
        Konverge.process(TYPE_DEBUG, s_textStackEnabled ? string : text, string, opaque);
    }

    public static void error(Exception exception) {
        if (!s_initialized) {
            return;
        }
        Konverge.preprocess(TYPE_ERROR, (Throwable)exception, (String)null);
    }

    public static void error(Exception exception, JSONObject opaque) {
        if (!s_initialized) {
            return;
        }
        Konverge.preprocess(TYPE_ERROR, (Throwable)exception, opaque);
    }

    public static void error(String text) {
        if (!s_initialized) {
            return;
        }
        String string = Konverge.callStack(text);
        Konverge.process(TYPE_ERROR, s_textStackEnabled ? string : text, string, (String)null);
    }

    public static void error(String text, JSONObject opaque) {
        if (!s_initialized) {
            return;
        }
        String string = Konverge.callStack(text);
        Konverge.process(TYPE_ERROR, s_textStackEnabled ? string : text, string, opaque);
    }

    public static void exception(Exception exception) {
        if (!s_initialized) {
            return;
        }
        Konverge.preprocess(TYPE_EXCEPTION, (Throwable)exception, (String)null);
    }

    public static void exception(Exception exception, JSONObject opaque) {
        if (!s_initialized) {
            return;
        }
        Konverge.preprocess(TYPE_EXCEPTION, (Throwable)exception, opaque);
    }

    public static void fatal(Exception exception) {
        if (!s_initialized) {
            return;
        }
        Konverge.preprocess(TYPE_FATAL, (Throwable)exception, (String)null);
    }

    public static void fatal(Exception exception, JSONObject opaque) {
        if (!s_initialized) {
            return;
        }
        Konverge.preprocess(TYPE_FATAL, (Throwable)exception, opaque);
    }

    public static void fatal(String text) {
        if (!s_initialized) {
            return;
        }
        String string = Konverge.callStack(text);
        Konverge.process(TYPE_FATAL, s_textStackEnabled ? string : text, string, (String)null);
    }

    public static void fatal(String text, JSONObject opaque) {
        if (!s_initialized) {
            return;
        }
        String string = Konverge.callStack(text);
        Konverge.process(TYPE_FATAL, s_textStackEnabled ? string : text, string, opaque);
    }

    public static void feedback(String text) {
        if (!s_initialized) {
            return;
        }
        Konverge.process(TYPE_FEEDBACK, text, null, (String)null);
    }

    public static void feedback(String text, JSONObject opaque) {
        if (!s_initialized) {
            return;
        }
        Konverge.process(TYPE_FEEDBACK, text, null, opaque);
    }

    private static JSONObject getExtra() {
        JSONObject jSONObject = new JSONObject();
        for (IExtra iExtra : s_extra) {
            try {
                iExtra.get(jSONObject);
            }
            catch (Exception exception) {
                if (!s_debugEnabled) continue;
                exception.printStackTrace();
            }
        }
        return jSONObject;
    }

    public static void info(Exception exception) {
        if (!s_initialized) {
            return;
        }
        Konverge.preprocess(TYPE_INFO, (Throwable)exception, (String)null);
    }

    public static void info(Exception exception, JSONObject opaque) {
        if (!s_initialized) {
            return;
        }
        Konverge.preprocess(TYPE_INFO, (Throwable)exception, opaque);
    }

    public static void info(String text) {
        if (!s_initialized) {
            return;
        }
        String string = Konverge.callStack(text);
        Konverge.process(TYPE_INFO, s_textStackEnabled ? string : text, string, (String)null);
    }

    public static void info(String text, JSONObject opaque) {
        if (!s_initialized) {
            return;
        }
        String string = Konverge.callStack(text);
        Konverge.process(TYPE_INFO, s_textStackEnabled ? string : text, string, opaque);
    }

    public static synchronized void initialize() {
        block9: {
            try {
                JSONObject jSONObject = new JSONObject(Utility.toString(new FileInputStream(new File(URLDecoder.decode(Agent.class.getProtectionDomain().getCodeSource().getLocation().getPath(), "UTF-8")).getParentFile().getPath() + File.separator + "konverge.json")));
                String string = null;
                String string2 = null;
                String string3 = null;
                boolean bl = true;
                Iterator iterator = jSONObject.keys();
                while (iterator.hasNext()) {
                    String string4 = (String)iterator.next();
                    if (string4.equalsIgnoreCase("Server")) {
                        string = jSONObject.optString(string4);
                        continue;
                    }
                    if (string4.equalsIgnoreCase("APIKey")) {
                        string2 = jSONObject.optString(string4);
                        continue;
                    }
                    if (string4.equalsIgnoreCase("Version")) {
                        string3 = jSONObject.optString(string4);
                        continue;
                    }
                    if (!string4.equalsIgnoreCase("UseSSL")) continue;
                    bl = jSONObject.optString(string4).equalsIgnoreCase("true") || jSONObject.optBoolean(string4);
                }
                if (string != null && string2 != null && string3 != null) {
                    Konverge.initialize(string, string2, string3, bl);
                } else if (string2 != null && string3 != null) {
                    Konverge.initialize(string2, string3);
                }
            }
            catch (Exception exception) {
                if (!s_debugEnabled) break block9;
                exception.printStackTrace();
            }
        }
    }

    public static synchronized void initialize(String apiKey, String version) {
        Konverge.initialize("api.konverge.co", apiKey, version, true);
    }

    public static synchronized void initialize(String server, String apiKey, String version, boolean useSSL) {
        s_initialized = false;
        s_debugEnabled = true;
        s_localLogEnabled = false;
        s_textStackEnabled = false;
        s_extra.clear();
        if (server == null || apiKey == null || version == null) {
            return;
        }
        s_server = server;
        s_apiKey = apiKey;
        s_version = version;
        s_protocol = useSSL ? "https://" : "http://";
        Thread.UncaughtExceptionHandler uncaughtExceptionHandler = Thread.getDefaultUncaughtExceptionHandler();
        if (!(uncaughtExceptionHandler instanceof ExceptionHandler)) {
            Thread.setDefaultUncaughtExceptionHandler(new ExceptionHandler());
        }
        s_initialized = true;
    }

    public static boolean isInitialized() {
        return s_initialized;
    }

    public static boolean isLocalLogEnabled() {
        return s_localLogEnabled;
    }

    protected static void preprocess(String type, Throwable throwable, JSONObject opaque) {
        StringWriter stringWriter = new StringWriter();
        throwable.printStackTrace(new PrintWriter(stringWriter));
        String string = stringWriter.toString();
        Konverge.process(type, string, string, opaque);
    }

    protected static void preprocess(String type, Throwable throwable, String opaque) {
        StringWriter stringWriter = new StringWriter();
        throwable.printStackTrace(new PrintWriter(stringWriter));
        String string = stringWriter.toString();
        Konverge.process(type, string, string, opaque);
    }

    protected static void process(String type, String text, String stack, JSONObject opaque) {
        try {
            new Thread(new Konverge(type, text, stack, opaque != null ? opaque.toString() : null, Konverge.getExtra())).start();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    protected static void process(String type, String text, String stack, String opaque) {
        try {
            new Thread(new Konverge(type, text, stack, opaque, Konverge.getExtra())).start();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public static void setDebugEnabled(boolean enabled) {
        s_debugEnabled = enabled;
    }

    public static void setLocalLogEnabled(boolean enabled) {
        s_localLogEnabled = enabled;
    }

    public static void setTextStackEnabled(boolean enabled) {
        s_textStackEnabled = enabled;
    }

    public static void trace(String category, String message) {
        if (!s_initialized) {
            return;
        }
        Thread thread = new Thread(new Konverge$1(category, message));
        try {
            thread.start();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static void uncaught(Throwable throwable) {
        if (!s_initialized) {
            return;
        }
        Konverge.preprocess(TYPE_UNCAUGHT, throwable, (String)null);
    }

    public static synchronized void uninitialize() {
        s_initialized = false;
        ExceptionHandler.restoreOriginalHandler();
    }

    public static void warning(Exception exception) {
        if (!s_initialized) {
            return;
        }
        Konverge.preprocess(TYPE_WARNING, (Throwable)exception, (String)null);
    }

    public static void warning(Exception exception, JSONObject opaque) {
        if (!s_initialized) {
            return;
        }
        Konverge.preprocess(TYPE_WARNING, (Throwable)exception, opaque);
    }

    public static void warning(String text) {
        if (!s_initialized) {
            return;
        }
        String string = Konverge.callStack(text);
        Konverge.process(TYPE_WARNING, s_textStackEnabled ? string : text, string, (String)null);
    }

    public static void warning(String text, JSONObject opaque) {
        if (!s_initialized) {
            return;
        }
        String string = Konverge.callStack(text);
        Konverge.process(TYPE_WARNING, s_textStackEnabled ? string : text, string, opaque);
    }

    private Konverge() {
    }

    private Konverge(String type, String text, String stack, String opaque, JSONObject extra) {
        this.m_type = type;
        this.m_text = text;
        this.m_stack = stack;
        this.m_extra = extra;
        this.m_opaque = opaque;
    }

    @Override
    public void run() {
        block10: {
            try {
                Object object;
                block9: {
                    if (s_localLogEnabled && this.m_text != null) {
                        System.out.println(this.m_text.trim());
                    }
                    try {
                        if (this.m_stack != null) {
                            this.m_extra.put("CallStack", this.m_stack);
                        }
                        object = new JSONObject();
                        for (String object2 : System.getenv().keySet()) {
                            ((JSONObject)object).putOpt(object2, System.getenv().get(object2));
                        }
                        this.m_extra.put("Environment", object);
                        JSONObject jSONObject = new JSONObject();
                        for (Object object2 : System.getProperties().keySet()) {
                            jSONObject.putOpt((String)object2, System.getProperties().get(object2));
                        }
                        this.m_extra.put("Properties", jSONObject);
                    }
                    catch (Throwable throwable) {
                        if (!s_debugEnabled) break block9;
                        throwable.printStackTrace();
                    }
                }
                object = new Request(s_protocol + s_server + "/rest/event-add.jsp").setParameter("APIKey", s_apiKey).setParameter("Event", this.m_text != null ? this.m_text.trim() : "").setParameter("Extra", this.m_extra.toString()).setParameter("Locale", Locale.getDefault().getLanguage() + "-" + Locale.getDefault().getCountry()).setParameter("Platform", 4L).setParameter("Time", System.currentTimeMillis() / 1000L).setParameter("Type", this.m_type).setParameter("Version", s_version);
                if (this.m_opaque != null && this.m_opaque.startsWith("{")) {
                    ((Request)object).setParameter("Opaque", this.m_opaque);
                }
                ((Request)object).execute();
            }
            catch (Throwable throwable) {
                if (!s_debugEnabled) break block10;
                throwable.printStackTrace();
            }
        }
    }

    static /* synthetic */ String access$000() {
        return s_version;
    }

    static /* synthetic */ String access$100() {
        return s_apiKey;
    }

    static /* synthetic */ String access$200() {
        return s_protocol;
    }

    static /* synthetic */ String access$300() {
        return s_server;
    }

    static /* synthetic */ boolean access$400() {
        return s_debugEnabled;
    }

    static {
        s_extra = new LinkedList<IExtra>();
    }
}

