/**
 * Copyright (C) 2009-2013 Nasrollah Kavian - All rights reserved.
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see http://www.gnu.org/licenses/
 */
package io.konverge.library;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.security.DigestInputStream;
import java.security.MessageDigest;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Enumeration;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.json.JSONArray;

public final class Utility {

    public static final boolean containsInsensitive(final List<String> list, final String string) {
        final String search = string.toLowerCase();
        for(int i = 0; i < list.size(); i++) {
            if(list.get(i).toLowerCase().equals(search)) {
                return true;
            }
        }
        return false;
    }

    public static final String convertToHex(final byte[] data) {
        final StringBuffer buffer = new StringBuffer();
        for(final byte element : data) {
            int halfbyte = element >>> 4 & 0x0F;
            int two_halfs = 0;
            do {
                if(0 <= halfbyte && halfbyte <= 9) {
                    buffer.append((char)('0' + halfbyte));
                }
                else {
                    buffer.append((char)('a' + (halfbyte - 10)));
                }
                halfbyte = element & 0x0F;
            }
            while(two_halfs++ < 1);
        }
        return buffer.toString();
    }

    public static JSONArray convertToJSONArray(final Collection<String> values) {
        final JSONArray array = new JSONArray();
        if(values != null) {
            for(final String value : values) {
                array.put(value);
            }
        }
        return array;
    }

    public static JSONArray convertToJSONArray(final Enumeration<String> enumeration) {
        final JSONArray array = new JSONArray();
        if(enumeration != null) {
            while(enumeration.hasMoreElements()) {
                array.put(enumeration.nextElement());
            }
        }
        return array;
    }

    public static JSONArray convertToJSONArray(final String[] values) {
        final JSONArray array = new JSONArray();
        if(values != null) {
            for(final String value : values) {
                array.put(value);
            }
        }
        return array;
    }

    public static <T>List<T> convertToList(final Enumeration<T> enumeration) {
        final List<T> list = new LinkedList<T>();
        if(enumeration != null) {
            while(enumeration.hasMoreElements()) {
                list.add(enumeration.nextElement());
            }
        }
        return list;
    }

    public static final String join(final List<String> items, final String delimiter) {
        final StringBuffer buffer = new StringBuffer();
        for(int x = 0; x < items.size(); x++) {
            if(buffer.length() > 0) {
                buffer.append(delimiter);
            }
            buffer.append(items.get(x));
        }
        return buffer.toString();
    }

    public static final String join(final Map<String, String> items, final String delimiter, final String seperator) {
        final StringBuffer buffer = new StringBuffer();
        for(final String key : items.keySet()) {
            if(buffer.length() > 0) {
                buffer.append(seperator);
            }
            buffer.append(key);
            buffer.append(delimiter);
            buffer.append(items.get(key));
        }
        return buffer.toString();
    }

    public static final String join(final String[] items, final String delimiter) {
        final StringBuffer buffer = new StringBuffer();
        if(items.length > 0) {
            for(int x = 0; x < items.length - 1; x++) {
                buffer.append(items[x]);
                buffer.append(delimiter);
            }
            buffer.append(items[items.length - 1]);
        }
        return buffer.toString();
    }

    public static String MD5(final File file) {
        try {
            final MessageDigest md = MessageDigest.getInstance("MD5");
            final InputStream is = new DigestInputStream(new FileInputStream(file), md);
            final byte[] buffer = new byte[8192];
            while(is.read(buffer) != -1) {
                ;
            }
            is.close();
            return convertToHex(md.digest());
        }
        catch(final Exception e) {
        }
        return "";
    }

    public static final String MD5(final String text) {
        try {
            final MessageDigest md = MessageDigest.getInstance("MD5");
            md.update(text.getBytes("UTF-8"));
            return convertToHex(md.digest());
        }
        catch(final Exception e) {
        }
        return "";
    }

    public static final boolean pipe(final InputStream input, final OutputStream output) {
        try {
            byte[] buffer = new byte[64 * 1024];
            int nread;
            synchronized(input) {
                while((nread = input.read(buffer, 0, buffer.length)) >= 0) {
                    output.write(buffer, 0, nread);
                    output.flush();
                }
            }
            output.flush();
            buffer = null;
            return true;
        }
        catch(final Exception e) {
        }
        return false;
    }

    public static int reflectInt(final Object object, final String name) {
        try {
            return object.getClass().getDeclaredField(name).getInt(object);
        }
        catch(final Exception e) {
        }
        return 0;
    }

    public static String reflectString(final Object object, final String name) {
        try {
            return (String)object.getClass().getDeclaredField(name).get(object);
        }
        catch(final Exception e) {
        }
        return "";
    }

    public static final String SHA1(final String text) {
        try {
            final MessageDigest md = MessageDigest.getInstance("SHA-1");
            md.update(text.getBytes("UTF-8"));
            return convertToHex(md.digest());
        }
        catch(final Exception e) {
        }
        return "";
    }

    public static final void sleep(final long time) {
        try {
            Thread.sleep(time);
        }
        catch(final Exception e) {
        }
    }

    public static final List<String> split(final String s, final String delimiter) {
        final List<String> result = new ArrayList<String>();
        final int length = s.length();
        int cur = -1;
        int next;

        if(length == 0) {
            return result;
        }
        while(true) {
            next = s.indexOf(delimiter, cur + 1);
            if(next == -1) {
                result.add(s.substring(cur + 1));
                break;
            }
            else if(next == length - 1) {
                result.add(s.substring(cur + 1, next));
                break;
            }
            else {
                result.add(s.substring(cur + 1, next));
                cur = next;
            }
        }
        return result;
    }

    public static String toByteSize(final long startSize) {
        final String[] abrv = new String[] {"B", "KB", "MB", "GB", "TB", "PB"};
        double size = startSize;
        int count = 0;
        while(size >= 1024) {
            ++count;
            size /= 1024;
        }
        return (count > 0 ? new DecimalFormat("#,###.#").format(size) : String.format("%,f", size)) + " " + abrv[count];
    }

    public static String toString(final InputStream input) {
        // TODO: Needs something similar to IOUtils instead of this.
        final StringBuffer buffer = new StringBuffer();
        try {
            final BufferedReader dataStream = new BufferedReader(new InputStreamReader(input, "UTF-8"), 8192);
            String line = null;
            try {
                while((line = dataStream.readLine()) != null) {
                    buffer.append(line).append("\n");
                }
            }
            catch(final Exception e) {
                e.printStackTrace();
            }
            finally {
                try {
                    input.close();
                }
                catch(final Exception e) {
                }
            }
        }
        catch(final Exception e) {
        }
        return buffer.toString();
    }

}
