/**
 * Copyright (C) 2009-2013 Nasrollah Kavian - All rights reserved.
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see http://www.gnu.org/licenses/
 */
package io.konverge.library;

import java.lang.Thread.UncaughtExceptionHandler;

final class ExceptionHandler implements UncaughtExceptionHandler {

    private static UncaughtExceptionHandler m_uncaughtExceptionHandler;

    public static void restoreOriginalHandler() {
        if(m_uncaughtExceptionHandler != null) {
            Thread.setDefaultUncaughtExceptionHandler(m_uncaughtExceptionHandler);
        }
    }

    public ExceptionHandler() {
        if(m_uncaughtExceptionHandler == null) {
            m_uncaughtExceptionHandler = Thread.getDefaultUncaughtExceptionHandler();
        }
    }

    private void report(final Thread thread, final Throwable throwable) {
        // Preferred option to report the error.
        Konverge.uncaught(throwable);

        // A second option to report the error.
        //throw new RuntimeException(throwable);
    }

    private void terminate(final Thread thread, final Throwable throwable) {
        // Avoid terminating the container or app.
        //System.exit(10);

        // A second option to kill the activity.
        //if(m_uncaughtExceptionHandler != null)
        //   {
        //   m_uncaughtExceptionHandler.uncaughtException(thread,throwable);
        //   }
    }

    @Override
    public void uncaughtException(final Thread thread, final Throwable throwable) {
        report(thread, throwable);

        terminate(thread, throwable);
    }

}
