/**
 * Copyright (C) 2009-2013 Nasrollah Kavian - All rights reserved.
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see http://www.gnu.org/licenses/
 */
package io.konverge.library;

import java.lang.instrument.Instrumentation;

/**
 * Konverge Agent.
 */
public final class Agent {

    /**
     * Dynamically load the agent at runtime.
     * 
     * @param arguments
     * @param instrumentation
     * @throws Exception
     */
    public static void agentmain(final String arguments, final Instrumentation instrumentation) throws Exception {
        initialize(arguments, instrumentation);
    }

    private static void initialize(final String arguments, final Instrumentation instrumentation) throws Exception {
        Konverge.initialize();
    }

    /**
     * Statically load the agent at startup.
     * 
     * @param arguments
     * @param instrumentation
     * @throws Exception
     */
    public static void premain(final String arguments, final Instrumentation instrumentation) throws Exception {
        initialize(arguments, instrumentation);
    }

}
