/*
 * Decompiled with CFR 0.152.
 */
package org.json.zip;

import org.json.Kim;
import org.json.zip.JSONzip;
import org.json.zip.Keep;
import org.json.zip.PostMortem;
import org.json.zip.TrieKeep$Node;

class TrieKeep
extends Keep {
    private int[] froms;
    private int[] thrus;
    private TrieKeep$Node root;
    private Kim[] kims;

    public TrieKeep(int bits) {
        super(bits);
        this.froms = new int[this.capacity];
        this.thrus = new int[this.capacity];
        this.kims = new Kim[this.capacity];
        this.root = new TrieKeep$Node(this);
    }

    public Kim kim(int integer) {
        Kim kim = this.kims[integer];
        int n = this.froms[integer];
        int n2 = this.thrus[integer];
        if (n != 0 || n2 != kim.length) {
            kim = new Kim(kim, n, n2);
            this.froms[integer] = 0;
            this.thrus[integer] = kim.length;
            this.kims[integer] = kim;
        }
        return kim;
    }

    public int length(int integer) {
        return this.thrus[integer] - this.froms[integer];
    }

    public int match(Kim kim, int from, int thru) {
        TrieKeep$Node trieKeep$Node = this.root;
        int n = -1;
        for (int i = from; i < thru && (trieKeep$Node = trieKeep$Node.get(kim.get(i))) != null; ++i) {
            if (TrieKeep$Node.access$000(trieKeep$Node) != -1) {
                n = TrieKeep$Node.access$000(trieKeep$Node);
            }
            ++from;
        }
        return n;
    }

    public boolean postMortem(PostMortem pm) {
        boolean bl = true;
        TrieKeep trieKeep = (TrieKeep)pm;
        if (this.length != trieKeep.length) {
            JSONzip.log("\nLength " + this.length + " <> " + trieKeep.length);
            return false;
        }
        if (this.capacity != trieKeep.capacity) {
            JSONzip.log("\nCapacity " + this.capacity + " <> " + trieKeep.capacity);
            return false;
        }
        for (int i = 0; i < this.length; ++i) {
            Kim kim;
            Kim kim2 = this.kim(i);
            if (kim2.equals(kim = trieKeep.kim(i))) continue;
            JSONzip.log("\n[" + i + "] " + kim2 + " <> " + kim);
            bl = false;
        }
        return bl && this.root.postMortem(trieKeep.root);
    }

    public void registerMany(Kim kim) {
        int n = kim.length;
        int n2 = this.capacity - this.length;
        if (n2 > 40) {
            n2 = 40;
        }
        int n3 = n - 2;
        for (int i = 0; i < n3; ++i) {
            int n4 = n - i;
            if (n4 > 10) {
                n4 = 10;
            }
            n4 += i;
            TrieKeep$Node trieKeep$Node = this.root;
            for (int j = i; j < n4; ++j) {
                TrieKeep$Node trieKeep$Node2 = trieKeep$Node.vet(kim.get(j));
                if (TrieKeep$Node.access$000(trieKeep$Node2) == -1 && j - i >= 2) {
                    TrieKeep$Node.access$002(trieKeep$Node2, this.length);
                    this.uses[this.length] = 1L;
                    this.kims[this.length] = kim;
                    this.froms[this.length] = i;
                    this.thrus[this.length] = j + 1;
                    ++this.length;
                    if (--n2 <= 0) {
                        return;
                    }
                }
                trieKeep$Node = trieKeep$Node2;
            }
        }
    }

    public void registerOne(Kim kim) {
        int n = this.registerOne(kim, 0, kim.length);
        if (n != -1) {
            this.kims[n] = kim;
        }
    }

    public int registerOne(Kim kim, int from, int thru) {
        if (this.length < this.capacity) {
            int n;
            TrieKeep$Node trieKeep$Node = this.root;
            for (n = from; n < thru; ++n) {
                trieKeep$Node = trieKeep$Node.vet(kim.get(n));
            }
            if (TrieKeep$Node.access$000(trieKeep$Node) == -1) {
                n = this.length++;
                TrieKeep$Node.access$002(trieKeep$Node, n);
                this.uses[n] = 1L;
                this.kims[n] = kim;
                this.froms[n] = from;
                this.thrus[n] = thru;
                return n;
            }
        }
        return -1;
    }

    public void reserve() {
        if (this.capacity - this.length < 40) {
            int n = 0;
            this.root = new TrieKeep$Node(this);
            for (int i = 0; i < this.capacity; ++i) {
                if (this.uses[i] <= 1L) continue;
                Kim kim = this.kims[i];
                int n2 = this.thrus[i];
                TrieKeep$Node trieKeep$Node = this.root;
                for (int j = this.froms[i]; j < n2; ++j) {
                    TrieKeep$Node trieKeep$Node2;
                    trieKeep$Node = trieKeep$Node2 = trieKeep$Node.vet(kim.get(j));
                }
                TrieKeep$Node.access$002(trieKeep$Node, n);
                this.uses[n] = TrieKeep.age(this.uses[i]);
                this.froms[n] = this.froms[i];
                this.thrus[n] = n2;
                this.kims[n] = kim;
                ++n;
            }
            if (this.capacity - n < 40) {
                this.power = 0;
                this.root = new TrieKeep$Node(this);
                n = 0;
            }
            this.length = n;
            while (n < this.capacity) {
                this.uses[n] = 0L;
                this.kims[n] = null;
                this.froms[n] = 0;
                this.thrus[n] = 0;
                ++n;
            }
        }
    }

    public Object value(int integer) {
        return this.kim(integer);
    }
}

