/*
 * Decompiled with CFR 0.152.
 */
package org.json.zip;

import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;
import org.json.Kim;
import org.json.zip.BitWriter;
import org.json.zip.Huff;
import org.json.zip.JSONzip;
import org.json.zip.Keep;

public class Compressor
extends JSONzip {
    final BitWriter bitwriter;

    public Compressor(BitWriter bitwriter) {
        this.bitwriter = bitwriter;
    }

    private static int bcd(char digit) {
        if (digit >= '0' && digit <= '9') {
            return digit - 48;
        }
        switch (digit) {
            case '.': {
                return 10;
            }
            case '-': {
                return 11;
            }
            case '+': {
                return 12;
            }
        }
        return 13;
    }

    public void flush() throws JSONException {
        this.pad(8);
    }

    private void one() throws JSONException {
        this.write(1, 1);
    }

    public void pad(int factor) throws JSONException {
        try {
            this.bitwriter.pad(factor);
        }
        catch (Throwable throwable) {
            throw new JSONException(throwable);
        }
    }

    private void write(int integer, int width) throws JSONException {
        try {
            this.bitwriter.write(integer, width);
        }
        catch (Throwable throwable) {
            throw new JSONException(throwable);
        }
    }

    private void write(int integer, Huff huff) throws JSONException {
        huff.write(integer, this.bitwriter);
    }

    private void write(Kim kim, Huff huff) throws JSONException {
        this.write(kim, 0, kim.length, huff);
    }

    private void write(Kim kim, int from, int thru, Huff huff) throws JSONException {
        for (int i = from; i < thru; ++i) {
            this.write(kim.get(i), huff);
        }
    }

    private void writeAndTick(int integer, Keep keep) throws JSONException {
        int n = keep.bitsize();
        keep.tick(integer);
        this.write(integer, n);
    }

    private void writeArray(JSONArray jsonarray) throws JSONException {
        boolean bl = false;
        int n = jsonarray.length();
        if (n == 0) {
            this.write(1, 3);
        } else {
            Object object = jsonarray.get(0);
            if (object == null) {
                object = JSONObject.NULL;
            }
            if (object instanceof String) {
                bl = true;
                this.write(6, 3);
                this.writeString((String)object);
            } else {
                this.write(7, 3);
                this.writeValue(object);
            }
            for (int i = 1; i < n; ++i) {
                object = jsonarray.get(i);
                if (object == null) {
                    object = JSONObject.NULL;
                }
                if (object instanceof String != bl) {
                    this.zero();
                }
                this.one();
                if (object instanceof String) {
                    this.writeString((String)object);
                    continue;
                }
                this.writeValue(object);
            }
            this.zero();
            this.zero();
        }
    }

    private void writeJSON(Object value) throws JSONException {
        if (JSONObject.NULL.equals(value)) {
            this.write(4, 3);
        } else if (Boolean.FALSE.equals(value)) {
            this.write(3, 3);
        } else if (Boolean.TRUE.equals(value)) {
            this.write(2, 3);
        } else {
            if (value instanceof Map) {
                value = new JSONObject((Map)value);
            } else if (value instanceof Collection) {
                value = new JSONArray((Collection)value);
            } else if (value.getClass().isArray()) {
                value = new JSONArray(value);
            }
            if (value instanceof JSONObject) {
                this.writeObject((JSONObject)value);
            } else if (value instanceof JSONArray) {
                this.writeArray((JSONArray)value);
            } else {
                throw new JSONException("Unrecognized object");
            }
        }
    }

    private void writeName(String name) throws JSONException {
        Kim kim = new Kim(name);
        int n = this.namekeep.find(kim);
        if (n != -1) {
            this.one();
            this.writeAndTick(n, this.namekeep);
        } else {
            this.zero();
            this.write(kim, this.namehuff);
            this.write(256, this.namehuff);
            this.namekeep.register(kim);
        }
    }

    private void writeObject(JSONObject jsonobject) throws JSONException {
        boolean bl = true;
        Iterator iterator = jsonobject.keys();
        while (iterator.hasNext()) {
            Object e = iterator.next();
            if (!(e instanceof String)) continue;
            if (bl) {
                bl = false;
                this.write(5, 3);
            } else {
                this.one();
            }
            this.writeName((String)e);
            Object object = jsonobject.get((String)e);
            if (object instanceof String) {
                this.zero();
                this.writeString((String)object);
                continue;
            }
            this.one();
            this.writeValue(object);
        }
        if (bl) {
            this.write(0, 3);
        } else {
            this.zero();
        }
    }

    private void writeString(String string) throws JSONException {
        if (string.length() == 0) {
            this.zero();
            this.zero();
            this.write(256, this.substringhuff);
            this.zero();
        } else {
            Kim kim = new Kim(string);
            int n = this.stringkeep.find(kim);
            if (n != -1) {
                this.one();
                this.writeAndTick(n, this.stringkeep);
            } else {
                this.writeSubstring(kim);
                this.stringkeep.register(kim);
            }
        }
    }

    private void writeSubstring(Kim kim) throws JSONException {
        this.substringkeep.reserve();
        this.zero();
        int n = 0;
        int n2 = kim.length;
        int n3 = n2 - 3;
        int n4 = -1;
        int n5 = 0;
        while (true) {
            int n6;
            int n7 = -1;
            for (n6 = n; n6 <= n3 && (n7 = this.substringkeep.match(kim, n6, n2)) == -1; ++n6) {
            }
            if (n7 == -1) break;
            if (n != n6) {
                this.zero();
                this.write(kim, n, n6, this.substringhuff);
                this.write(256, this.substringhuff);
                if (n4 != -1) {
                    this.substringkeep.registerOne(kim, n4, n5);
                    n4 = -1;
                }
            }
            this.one();
            this.writeAndTick(n7, this.substringkeep);
            n = n6 + this.substringkeep.length(n7);
            if (n4 != -1) {
                this.substringkeep.registerOne(kim, n4, n5);
                n4 = -1;
            }
            n4 = n6;
            n5 = n + 1;
        }
        this.zero();
        if (n < n2) {
            this.write(kim, n, n2, this.substringhuff);
            if (n4 != -1) {
                this.substringkeep.registerOne(kim, n4, n5);
            }
        }
        this.write(256, this.substringhuff);
        this.zero();
        this.substringkeep.registerMany(kim);
    }

    private void writeValue(Object value) throws JSONException {
        if (value instanceof Number) {
            long l;
            String string = JSONObject.numberToString((Number)value);
            int n = this.values.find(string);
            if (n != -1) {
                this.write(2, 2);
                this.writeAndTick(n, this.values);
                return;
            }
            if ((value instanceof Integer || value instanceof Long) && (l = ((Number)value).longValue()) >= 0L && l < 16384L) {
                this.write(0, 2);
                if (l < 16L) {
                    this.zero();
                    this.write((int)l, 4);
                    return;
                }
                this.one();
                if (l < 128L) {
                    this.zero();
                    this.write((int)l, 7);
                    return;
                }
                this.one();
                this.write((int)l, 14);
                return;
            }
            this.write(1, 2);
            for (int i = 0; i < string.length(); ++i) {
                this.write(Compressor.bcd(string.charAt(i)), 4);
            }
            this.write(endOfNumber, 4);
            this.values.register(string);
        } else {
            this.write(3, 2);
            this.writeJSON(value);
        }
    }

    private void zero() throws JSONException {
        this.write(0, 1);
    }

    public void zip(JSONObject jsonobject) throws JSONException {
        this.begin();
        this.writeJSON(jsonobject);
    }

    public void zip(JSONArray jsonarray) throws JSONException {
        this.begin();
        this.writeJSON(jsonarray);
    }
}

