/*
 * Decompiled with CFR 0.152.
 */
package org.json.zip;

import java.io.IOException;
import java.io.OutputStream;
import org.json.zip.BitInputStream;
import org.json.zip.BitWriter;

public class BitOutputStream
implements BitWriter {
    private long nrBits = 0L;
    private OutputStream out;
    private int unwritten;
    private int vacant = 8;

    public BitOutputStream(OutputStream out) {
        this.out = out;
    }

    public long nrBits() {
        return this.nrBits;
    }

    public void one() throws IOException {
        this.write(1, 1);
    }

    public void pad(int factor) throws IOException {
        int n = factor - (int)(this.nrBits % (long)factor);
        int n2 = n & 7;
        if (n2 > 0) {
            this.write(0, n2);
            n -= n2;
        }
        while (n > 0) {
            this.write(0, 8);
            n -= 8;
        }
        this.out.flush();
    }

    public void write(int bits, int width) throws IOException {
        if (bits == 0 && width == 0) {
            return;
        }
        if (width <= 0 || width > 32) {
            throw new IOException("Bad write width.");
        }
        while (width > 0) {
            int n = width;
            if (n > this.vacant) {
                n = this.vacant;
            }
            this.unwritten |= (bits >>> width - n & BitInputStream.mask[n]) << this.vacant - n;
            width -= n;
            this.nrBits += (long)n;
            this.vacant -= n;
            if (this.vacant != 0) continue;
            this.out.write(this.unwritten);
            this.unwritten = 0;
            this.vacant = 8;
        }
    }

    public void zero() throws IOException {
        this.write(0, 1);
    }
}

