/*
 * Decompiled with CFR 0.152.
 */
package org.json;

import java.util.Iterator;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;
import org.json.XML;
import org.json.XMLTokener;

public class JSONML {
    private static Object parse(XMLTokener x, boolean arrayForm, JSONArray ja) throws JSONException {
        String string = null;
        JSONArray jSONArray = null;
        JSONObject jSONObject = null;
        String string2 = null;
        while (true) {
            if (!x.more()) {
                throw x.syntaxError("Bad XML");
            }
            Object object = x.nextContent();
            if (object == XML.LT) {
                object = x.nextToken();
                if (object instanceof Character) {
                    if (object == XML.SLASH) {
                        object = x.nextToken();
                        if (!(object instanceof String)) {
                            throw new JSONException("Expected a closing name instead of '" + object + "'.");
                        }
                        if (x.nextToken() != XML.GT) {
                            throw x.syntaxError("Misshaped close tag");
                        }
                        return object;
                    }
                    if (object == XML.BANG) {
                        char c = x.next();
                        if (c == '-') {
                            if (x.next() == '-') {
                                x.skipPast("-->");
                                continue;
                            }
                            x.back();
                            continue;
                        }
                        if (c == '[') {
                            object = x.nextToken();
                            if (object.equals("CDATA") && x.next() == '[') {
                                if (ja == null) continue;
                                ja.put(x.nextCDATA());
                                continue;
                            }
                            throw x.syntaxError("Expected 'CDATA['");
                        }
                        int n = 1;
                        do {
                            if ((object = x.nextMeta()) == null) {
                                throw x.syntaxError("Missing '>' after '<!'.");
                            }
                            if (object == XML.LT) {
                                ++n;
                                continue;
                            }
                            if (object != XML.GT) continue;
                            --n;
                        } while (n > 0);
                        continue;
                    }
                    if (object == XML.QUEST) {
                        x.skipPast("?>");
                        continue;
                    }
                    throw x.syntaxError("Misshaped tag");
                }
                if (!(object instanceof String)) {
                    throw x.syntaxError("Bad tagName '" + object + "'.");
                }
                string2 = (String)object;
                jSONArray = new JSONArray();
                jSONObject = new JSONObject();
                if (arrayForm) {
                    jSONArray.put(string2);
                    if (ja != null) {
                        ja.put(jSONArray);
                    }
                } else {
                    jSONObject.put("tagName", string2);
                    if (ja != null) {
                        ja.put(jSONObject);
                    }
                }
                object = null;
                while (true) {
                    if (object == null) {
                        object = x.nextToken();
                    }
                    if (object == null) {
                        throw x.syntaxError("Misshaped tag");
                    }
                    if (!(object instanceof String)) break;
                    String string3 = (String)object;
                    if (!arrayForm && ("tagName".equals(string3) || "childNode".equals(string3))) {
                        throw x.syntaxError("Reserved attribute.");
                    }
                    object = x.nextToken();
                    if (object == XML.EQ) {
                        object = x.nextToken();
                        if (!(object instanceof String)) {
                            throw x.syntaxError("Missing value");
                        }
                        jSONObject.accumulate(string3, XML.stringToValue((String)object));
                        object = null;
                        continue;
                    }
                    jSONObject.accumulate(string3, "");
                }
                if (arrayForm && jSONObject.length() > 0) {
                    jSONArray.put(jSONObject);
                }
                if (object == XML.SLASH) {
                    if (x.nextToken() != XML.GT) {
                        throw x.syntaxError("Misshaped tag");
                    }
                    if (ja != null) continue;
                    if (arrayForm) {
                        return jSONArray;
                    }
                    return jSONObject;
                }
                if (object != XML.GT) {
                    throw x.syntaxError("Misshaped tag");
                }
                string = (String)JSONML.parse(x, arrayForm, jSONArray);
                if (string == null) continue;
                if (!string.equals(string2)) {
                    throw x.syntaxError("Mismatched '" + string2 + "' and '" + string + "'");
                }
                string2 = null;
                if (!arrayForm && jSONArray.length() > 0) {
                    jSONObject.put("childNodes", jSONArray);
                }
                if (ja != null) continue;
                if (arrayForm) {
                    return jSONArray;
                }
                return jSONObject;
            }
            if (ja == null) continue;
            ja.put(object instanceof String ? XML.stringToValue((String)object) : object);
        }
    }

    public static JSONArray toJSONArray(String string) throws JSONException {
        return JSONML.toJSONArray(new XMLTokener(string));
    }

    public static JSONArray toJSONArray(XMLTokener x) throws JSONException {
        return (JSONArray)JSONML.parse(x, true, null);
    }

    public static JSONObject toJSONObject(XMLTokener x) throws JSONException {
        return (JSONObject)JSONML.parse(x, false, null);
    }

    public static JSONObject toJSONObject(String string) throws JSONException {
        return JSONML.toJSONObject(new XMLTokener(string));
    }

    public static String toString(JSONArray ja) throws JSONException {
        int n;
        int n2;
        StringBuffer stringBuffer = new StringBuffer();
        String string = ja.getString(0);
        XML.noSpace(string);
        string = XML.escape(string);
        stringBuffer.append('<');
        stringBuffer.append(string);
        Object object = ja.opt(1);
        if (object instanceof JSONObject) {
            n2 = 2;
            JSONObject jSONObject = (JSONObject)object;
            Iterator iterator = jSONObject.keys();
            while (iterator.hasNext()) {
                String string2 = iterator.next().toString();
                XML.noSpace(string2);
                String string3 = jSONObject.optString(string2);
                if (string3 == null) continue;
                stringBuffer.append(' ');
                stringBuffer.append(XML.escape(string2));
                stringBuffer.append('=');
                stringBuffer.append('\"');
                stringBuffer.append(XML.escape(string3));
                stringBuffer.append('\"');
            }
        } else {
            n2 = 1;
        }
        if (n2 >= (n = ja.length())) {
            stringBuffer.append('/');
            stringBuffer.append('>');
        } else {
            stringBuffer.append('>');
            do {
                object = ja.get(n2);
                ++n2;
                if (object == null) continue;
                if (object instanceof String) {
                    stringBuffer.append(XML.escape(object.toString()));
                    continue;
                }
                if (object instanceof JSONObject) {
                    stringBuffer.append(JSONML.toString((JSONObject)object));
                    continue;
                }
                if (!(object instanceof JSONArray)) continue;
                stringBuffer.append(JSONML.toString((JSONArray)object));
            } while (n2 < n);
            stringBuffer.append('<');
            stringBuffer.append('/');
            stringBuffer.append(string);
            stringBuffer.append('>');
        }
        return stringBuffer.toString();
    }

    public static String toString(JSONObject jo) throws JSONException {
        StringBuffer stringBuffer = new StringBuffer();
        String string = jo.optString("tagName");
        if (string == null) {
            return XML.escape(jo.toString());
        }
        XML.noSpace(string);
        string = XML.escape(string);
        stringBuffer.append('<');
        stringBuffer.append(string);
        Iterator iterator = jo.keys();
        while (iterator.hasNext()) {
            String string2 = iterator.next().toString();
            if ("tagName".equals(string2) || "childNodes".equals(string2)) continue;
            XML.noSpace(string2);
            String string3 = jo.optString(string2);
            if (string3 == null) continue;
            stringBuffer.append(' ');
            stringBuffer.append(XML.escape(string2));
            stringBuffer.append('=');
            stringBuffer.append('\"');
            stringBuffer.append(XML.escape(string3));
            stringBuffer.append('\"');
        }
        JSONArray jSONArray = jo.optJSONArray("childNodes");
        if (jSONArray == null) {
            stringBuffer.append('/');
            stringBuffer.append('>');
        } else {
            stringBuffer.append('>');
            int n = jSONArray.length();
            for (int i = 0; i < n; ++i) {
                Object object = jSONArray.get(i);
                if (object == null) continue;
                if (object instanceof String) {
                    stringBuffer.append(XML.escape(object.toString()));
                    continue;
                }
                if (object instanceof JSONObject) {
                    stringBuffer.append(JSONML.toString((JSONObject)object));
                    continue;
                }
                if (object instanceof JSONArray) {
                    stringBuffer.append(JSONML.toString((JSONArray)object));
                    continue;
                }
                stringBuffer.append(object.toString());
            }
            stringBuffer.append('<');
            stringBuffer.append('/');
            stringBuffer.append(string);
            stringBuffer.append('>');
        }
        return stringBuffer.toString();
    }
}

