/*
 * Decompiled with CFR 0.152.
 */
package io.konverge.library;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.security.DigestInputStream;
import java.security.MessageDigest;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Enumeration;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.json.JSONArray;

public final class Utility {
    public static final boolean containsInsensitive(List<String> list, String string) {
        String string2 = string.toLowerCase();
        for (int i = 0; i < list.size(); ++i) {
            if (!list.get(i).toLowerCase().equals(string2)) continue;
            return true;
        }
        return false;
    }

    public static final String convertToHex(byte[] data) {
        StringBuffer stringBuffer = new StringBuffer();
        for (byte by : data) {
            int n = by >>> 4 & 0xF;
            int n2 = 0;
            do {
                if (0 <= n && n <= 9) {
                    stringBuffer.append((char)(48 + n));
                } else {
                    stringBuffer.append((char)(97 + (n - 10)));
                }
                n = by & 0xF;
            } while (n2++ < 1);
        }
        return stringBuffer.toString();
    }

    public static JSONArray convertToJSONArray(Collection<String> values) {
        JSONArray jSONArray = new JSONArray();
        if (values != null) {
            for (String string : values) {
                jSONArray.put(string);
            }
        }
        return jSONArray;
    }

    public static JSONArray convertToJSONArray(Enumeration<String> enumeration) {
        JSONArray jSONArray = new JSONArray();
        if (enumeration != null) {
            while (enumeration.hasMoreElements()) {
                jSONArray.put(enumeration.nextElement());
            }
        }
        return jSONArray;
    }

    public static JSONArray convertToJSONArray(String[] values) {
        JSONArray jSONArray = new JSONArray();
        if (values != null) {
            for (String string : values) {
                jSONArray.put(string);
            }
        }
        return jSONArray;
    }

    public static <T> List<T> convertToList(Enumeration<T> enumeration) {
        LinkedList<T> linkedList = new LinkedList<T>();
        if (enumeration != null) {
            while (enumeration.hasMoreElements()) {
                linkedList.add(enumeration.nextElement());
            }
        }
        return linkedList;
    }

    public static final String join(List<String> items, String delimiter) {
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < items.size(); ++i) {
            if (stringBuffer.length() > 0) {
                stringBuffer.append(delimiter);
            }
            stringBuffer.append(items.get(i));
        }
        return stringBuffer.toString();
    }

    public static final String join(Map<String, String> items, String delimiter, String seperator) {
        StringBuffer stringBuffer = new StringBuffer();
        for (String string : items.keySet()) {
            if (stringBuffer.length() > 0) {
                stringBuffer.append(seperator);
            }
            stringBuffer.append(string);
            stringBuffer.append(delimiter);
            stringBuffer.append(items.get(string));
        }
        return stringBuffer.toString();
    }

    public static final String join(String[] items, String delimiter) {
        StringBuffer stringBuffer = new StringBuffer();
        if (items.length > 0) {
            for (int i = 0; i < items.length - 1; ++i) {
                stringBuffer.append(items[i]);
                stringBuffer.append(delimiter);
            }
            stringBuffer.append(items[items.length - 1]);
        }
        return stringBuffer.toString();
    }

    public static String MD5(File file) {
        try {
            MessageDigest messageDigest = MessageDigest.getInstance("MD5");
            DigestInputStream digestInputStream = new DigestInputStream(new FileInputStream(file), messageDigest);
            byte[] byArray = new byte[8192];
            while (((InputStream)digestInputStream).read(byArray) != -1) {
            }
            ((InputStream)digestInputStream).close();
            return Utility.convertToHex(messageDigest.digest());
        }
        catch (Exception exception) {
            return "";
        }
    }

    public static final String MD5(String text) {
        try {
            MessageDigest messageDigest = MessageDigest.getInstance("MD5");
            messageDigest.update(text.getBytes("UTF-8"));
            return Utility.convertToHex(messageDigest.digest());
        }
        catch (Exception exception) {
            return "";
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final boolean pipe(InputStream input, OutputStream output) {
        try {
            byte[] byArray = new byte[65536];
            InputStream inputStream = input;
            synchronized (inputStream) {
                int n;
                while ((n = input.read(byArray, 0, byArray.length)) >= 0) {
                    output.write(byArray, 0, n);
                    output.flush();
                }
            }
            output.flush();
            byArray = null;
            return true;
        }
        catch (Exception exception) {
            return false;
        }
    }

    public static int reflectInt(Object object, String name) {
        try {
            return object.getClass().getDeclaredField(name).getInt(object);
        }
        catch (Exception exception) {
            return 0;
        }
    }

    public static String reflectString(Object object, String name) {
        try {
            return (String)object.getClass().getDeclaredField(name).get(object);
        }
        catch (Exception exception) {
            return "";
        }
    }

    public static final String SHA1(String text) {
        try {
            MessageDigest messageDigest = MessageDigest.getInstance("SHA-1");
            messageDigest.update(text.getBytes("UTF-8"));
            return Utility.convertToHex(messageDigest.digest());
        }
        catch (Exception exception) {
            return "";
        }
    }

    public static final void sleep(long time) {
        try {
            Thread.sleep(time);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static final List<String> split(String s, String delimiter) {
        ArrayList<String> arrayList = new ArrayList<String>();
        int n = s.length();
        int n2 = -1;
        if (n == 0) {
            return arrayList;
        }
        while (true) {
            int n3;
            if ((n3 = s.indexOf(delimiter, n2 + 1)) == -1) {
                arrayList.add(s.substring(n2 + 1));
                break;
            }
            if (n3 == n - 1) {
                arrayList.add(s.substring(n2 + 1, n3));
                break;
            }
            arrayList.add(s.substring(n2 + 1, n3));
            n2 = n3;
        }
        return arrayList;
    }

    public static String toByteSize(long startSize) {
        double d;
        String[] stringArray = new String[]{"B", "KB", "MB", "GB", "TB", "PB"};
        int n = 0;
        for (d = (double)startSize; d >= 1024.0; d /= 1024.0) {
            ++n;
        }
        return (n > 0 ? new DecimalFormat("#,###.#").format(d) : String.format("%,f", d)) + " " + stringArray[n];
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String toString(InputStream input) {
        StringBuffer stringBuffer = new StringBuffer();
        try {
            BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(input, "UTF-8"), 8192);
            String string = null;
            try {
                while ((string = bufferedReader.readLine()) != null) {
                    stringBuffer.append(string).append("\n");
                }
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
            finally {
                try {
                    input.close();
                }
                catch (Exception exception) {}
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return stringBuffer.toString();
    }
}

