/*
 * Decompiled with CFR 0.152.
 */
package io.konverge.library.servlet;

import io.konverge.library.IExtra;
import io.konverge.library.Konverge;
import io.konverge.library.Utility;
import java.io.IOException;
import java.util.Collection;
import java.util.Enumeration;
import java.util.Map;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.annotation.WebFilter;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

@WebFilter(filterName="KonvergeServletFilter", urlPatterns={"/*"})
public class KonvergeServletFilter
implements Filter {
    private static boolean s_collectExtra = true;
    private static ThreadLocal<HttpServletRequest> s_request = new ThreadLocal();
    private static ThreadLocal<HttpServletResponse> s_response = new ThreadLocal();

    public void destroy() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doFilter(HttpServletRequest request, HttpServletResponse response, FilterChain chain) throws IOException, ServletException {
        s_request.set(request);
        s_response.set(response);
        try {
            chain.doFilter((ServletRequest)request, (ServletResponse)response);
        }
        finally {
            s_request.remove();
            s_response.remove();
        }
    }

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        if (request instanceof HttpServletRequest && response instanceof HttpServletResponse) {
            this.doFilter((HttpServletRequest)request, (HttpServletResponse)response, chain);
        } else {
            this.doFilter(request, response, chain);
        }
    }

    public void init(FilterConfig config) throws ServletException {
        Konverge.addExtra((IExtra)new Extra());
    }

    private static class Extra
    implements IExtra {
        private Extra() {
        }

        private static void getAttributes(HttpServletRequest request, JSONObject extra) throws JSONException {
            JSONObject attributes = new JSONObject();
            for (String name : Utility.convertToList((Enumeration)request.getAttributeNames())) {
                attributes.put(name, request.getAttribute(name));
            }
            if (attributes.length() > 0) {
                extra.put("Attributes", (Object)attributes);
            }
        }

        private static void getCookies(HttpServletRequest request, JSONObject extra) throws JSONException {
            JSONObject cookies = new JSONObject();
            Cookie[] co0kies = request.getCookies();
            if (co0kies != null) {
                for (Cookie cookie : co0kies) {
                    cookies.put(cookie.getName(), (Object)cookie.getValue());
                }
            }
            if (cookies.length() > 0) {
                extra.put("Cookies", (Object)cookies);
            }
        }

        private static void getHeaders(HttpServletRequest request, JSONObject requ3st) throws JSONException {
            JSONObject headers = new JSONObject();
            for (String name : Utility.convertToList((Enumeration)request.getHeaderNames())) {
                if (name.equalsIgnoreCase("cookie")) continue;
                JSONArray values = Utility.convertToJSONArray((Enumeration)request.getHeaders(name));
                if (values.length() == 1) {
                    headers.put(name, values.get(0));
                    continue;
                }
                if (values.length() <= 1) continue;
                headers.put(name, (Object)values);
            }
            if (headers.length() > 0) {
                requ3st.put("Headers", (Object)headers);
            }
        }

        private static void getHeaders(HttpServletResponse response, JSONObject resp0nse) throws JSONException {
            JSONObject headers = new JSONObject();
            Collection names = response.getHeaderNames();
            if (names != null) {
                for (String name : names) {
                    JSONArray values = Utility.convertToJSONArray((Collection)response.getHeaders(name));
                    if (values.length() == 1) {
                        headers.put(name, values.get(0));
                        continue;
                    }
                    if (values.length() <= 1) continue;
                    headers.put(name, (Object)values);
                }
                if (headers.length() > 0) {
                    resp0nse.put("Headers", (Object)headers);
                }
            }
        }

        private static void getParameters(HttpServletRequest request, JSONObject extra) throws JSONException {
            Map parameterList = request.getParameterMap();
            if (parameterList != null) {
                JSONObject parameters = new JSONObject();
                for (String name : parameterList.keySet()) {
                    String[] values = (String[])parameterList.get(name);
                    if (values == null) {
                        parameters.put(name, (Object)"");
                        continue;
                    }
                    if (values.length == 1) {
                        parameters.put(name, (Object)values[0]);
                        continue;
                    }
                    parameters.put(name, (Object)Utility.convertToJSONArray((String[])values));
                }
                if (parameters.length() > 0) {
                    extra.put("Parameters", (Object)parameters);
                }
            }
        }

        private static void getRequest(HttpServletRequest request, JSONObject extra) throws JSONException {
            JSONObject requ3st = new JSONObject();
            requ3st.put("Authentication Type", (Object)request.getAuthType());
            requ3st.put("Character Encoding", (Object)request.getCharacterEncoding());
            requ3st.put("Content Length", request.getContentLength());
            requ3st.put("Content Type", (Object)request.getContentType());
            requ3st.put("Context Path", (Object)request.getContextPath());
            requ3st.put("Local Address", (Object)request.getLocalAddr());
            requ3st.put("Local Name", (Object)request.getLocalName());
            requ3st.put("Local Port", request.getLocalPort());
            requ3st.put("Method", (Object)request.getMethod());
            requ3st.put("Path Info", (Object)request.getPathInfo());
            requ3st.put("Path Translated", (Object)request.getPathTranslated());
            requ3st.put("Protocol", (Object)request.getProtocol());
            requ3st.put("Query String", (Object)request.getQueryString());
            requ3st.put("Remote Address", (Object)request.getRemoteAddr());
            requ3st.put("Remote Host", (Object)request.getRemoteHost());
            requ3st.put("Remote Port", request.getRemotePort());
            requ3st.put("Remote User", (Object)request.getRemoteUser());
            requ3st.put("Request URI", (Object)request.getRequestURI().replace("//", "/"));
            requ3st.put("Scheme", (Object)request.getScheme());
            requ3st.put("Server Name", (Object)request.getServerName());
            requ3st.put("Server Port", request.getServerPort());
            requ3st.put("Servlet Path", (Object)request.getServletPath());
            extra.put("Request", (Object)requ3st);
            Extra.getHeaders(request, requ3st);
        }

        private static void getResponse(HttpServletResponse response, JSONObject extra) throws JSONException {
            JSONObject resp0nse = new JSONObject();
            resp0nse.put("Character Encoding", (Object)response.getCharacterEncoding());
            resp0nse.put("Content Type", (Object)response.getContentType());
            resp0nse.put("HTTP Status", response.getStatus());
            extra.put("Response", (Object)resp0nse);
            Extra.getHeaders(response, resp0nse);
        }

        private static void getSession(HttpServletRequest request, JSONObject extra) throws JSONException {
            JSONObject session = new JSONObject();
            HttpSession sessi0n = request.getSession(false);
            if (sessi0n != null) {
                for (String name : Utility.convertToList((Enumeration)sessi0n.getAttributeNames())) {
                    session.put(name, sessi0n.getAttribute(name));
                }
            }
            if (session.length() > 0) {
                extra.put("Session", (Object)session);
            }
        }

        public void get(JSONObject extra) {
            if (!s_collectExtra) {
                return;
            }
            HttpServletRequest request = (HttpServletRequest)s_request.get();
            HttpServletResponse response = (HttpServletResponse)s_response.get();
            if (request != null && response != null) {
                try {
                    Extra.getRequest(request, extra);
                    Extra.getCookies(request, extra);
                    Extra.getSession(request, extra);
                    Extra.getAttributes(request, extra);
                    Extra.getParameters(request, extra);
                    Extra.getResponse(response, extra);
                }
                catch (JSONException e) {
                    s_collectExtra = false;
                    Konverge.exception((Exception)((Object)e));
                }
            } else {
                s_request.remove();
                s_response.remove();
            }
        }
    }
}

