/**
 * Copyright (C) 2009-2013 Nasrollah Kavian - All rights reserved.
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see http://www.gnu.org/licenses/
 */
package io.konverge.library.servlet;

import io.konverge.library.IExtra;
import io.konverge.library.Konverge;
import io.konverge.library.Utility;
import java.io.IOException;
import java.util.Collection;
import java.util.Map;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.annotation.WebFilter;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

/**
 * 
 */
@WebFilter(filterName = "KonvergeServletFilter", urlPatterns = {"/*"})
public class KonvergeServletFilter implements Filter {

    private static class Extra implements IExtra {

        private static void getAttributes(final HttpServletRequest request, final JSONObject extra) throws JSONException {
            final JSONObject attributes = new JSONObject();
            for(final String name : Utility.convertToList(request.getAttributeNames())) {
                attributes.put(name, request.getAttribute(name));
            }
            if(attributes.length() > 0) {
                extra.put("Attributes", attributes);
            }
        }

        private static void getCookies(final HttpServletRequest request, final JSONObject extra) throws JSONException {
            final JSONObject cookies = new JSONObject();
            final Cookie[] co0kies = request.getCookies();
            if(co0kies != null) {
                for(final Cookie cookie : co0kies) {
                    cookies.put(cookie.getName(), cookie.getValue());
                }
            }
            if(cookies.length() > 0) {
                extra.put("Cookies", cookies);
            }
        }

        private static void getHeaders(final HttpServletRequest request, final JSONObject requ3st) throws JSONException {
            final JSONObject headers = new JSONObject();
            for(final String name : Utility.convertToList(request.getHeaderNames())) {
                if(!name.equalsIgnoreCase("cookie")) {
                    final JSONArray values = Utility.convertToJSONArray(request.getHeaders(name));
                    if(values.length() == 1) {
                        headers.put(name, values.get(0));
                    }
                    else if(values.length() > 1) {
                        headers.put(name, values);
                    }
                }
            }
            if(headers.length() > 0) {
                requ3st.put("Headers", headers);
            }
        }

        private static void getHeaders(final HttpServletResponse response, final JSONObject resp0nse) throws JSONException {
            final JSONObject headers = new JSONObject();
            final Collection<String> names = response.getHeaderNames();
            if(names != null) {
                for(final String name : names) {
                    final JSONArray values = Utility.convertToJSONArray(response.getHeaders(name));
                    if(values.length() == 1) {
                        headers.put(name, values.get(0));
                    }
                    else if(values.length() > 1) {
                        headers.put(name, values);
                    }
                }
                if(headers.length() > 0) {
                    resp0nse.put("Headers", headers);
                }
            }
        }

        private static void getParameters(final HttpServletRequest request, final JSONObject extra) throws JSONException {
            // TODO: Timing??
            final Map<String, String[]> parameterList = request.getParameterMap();
            if(parameterList != null) {
                final JSONObject parameters = new JSONObject();
                for(final String name : parameterList.keySet()) {
                    final String[] values = parameterList.get(name);
                    if(values == null) {
                        parameters.put(name, "");
                    }
                    else if(values.length == 1) {
                        parameters.put(name, values[0]);
                    }
                    else {
                        parameters.put(name, Utility.convertToJSONArray(values));
                    }
                }
                if(parameters.length() > 0) {
                    extra.put("Parameters", parameters);
                }
            }
        }

        private static void getRequest(final HttpServletRequest request, final JSONObject extra) throws JSONException {
            final JSONObject requ3st = new JSONObject();
            requ3st.put("Authentication Type", request.getAuthType());
            requ3st.put("Character Encoding", request.getCharacterEncoding());
            requ3st.put("Content Length", request.getContentLength());
            requ3st.put("Content Type", request.getContentType());
            requ3st.put("Context Path", request.getContextPath());
            requ3st.put("Local Address", request.getLocalAddr());
            requ3st.put("Local Name", request.getLocalName());
            requ3st.put("Local Port", request.getLocalPort());
            requ3st.put("Method", request.getMethod());
            requ3st.put("Path Info", request.getPathInfo());
            requ3st.put("Path Translated", request.getPathTranslated());
            requ3st.put("Protocol", request.getProtocol());
            requ3st.put("Query String", request.getQueryString());
            requ3st.put("Remote Address", request.getRemoteAddr());
            requ3st.put("Remote Host", request.getRemoteHost());
            requ3st.put("Remote Port", request.getRemotePort());
            requ3st.put("Remote User", request.getRemoteUser());
            requ3st.put("Request URI", request.getRequestURI().replace("//", "/"));
            requ3st.put("Scheme", request.getScheme());
            requ3st.put("Server Name", request.getServerName());
            requ3st.put("Server Port", request.getServerPort());
            requ3st.put("Servlet Path", request.getServletPath());
            extra.put("Request", requ3st);

            getHeaders(request, requ3st);
        }

        private static void getResponse(final HttpServletResponse response, final JSONObject extra) throws JSONException {
            final JSONObject resp0nse = new JSONObject();
            resp0nse.put("Character Encoding", response.getCharacterEncoding());
            resp0nse.put("Content Type", response.getContentType());
            //resp0nse.put("",response.getHeaderNames());
            resp0nse.put("HTTP Status", response.getStatus());
            extra.put("Response", resp0nse);

            getHeaders(response, resp0nse);
        }

        private static void getSession(final HttpServletRequest request, final JSONObject extra) throws JSONException {
            final JSONObject session = new JSONObject();
            final HttpSession sessi0n = request.getSession(false);
            if(sessi0n != null) {
                for(final String name : Utility.convertToList(sessi0n.getAttributeNames())) {
                    session.put(name, sessi0n.getAttribute(name));
                }
            }
            if(session.length() > 0) {
                extra.put("Session", session);
            }
        }

        @Override
        public void get(final JSONObject extra) {
            if(!s_collectExtra) {
                return;
            }

            final HttpServletRequest request = s_request.get();
            final HttpServletResponse response = s_response.get();
            if(request != null && response != null) {
                try {
                    getRequest(request, extra);
                    getCookies(request, extra);
                    getSession(request, extra);
                    getAttributes(request, extra);
                    getParameters(request, extra);
                    getResponse(response, extra);

                    // TODO: extra.put("A",Utility.toString(request.getInputStream()));
                }
                catch(final JSONException e) {
                    s_collectExtra = false;
                    Konverge.exception(e);
                }
            }
            else {
                s_request.remove();
                s_response.remove();
            }
        }

    }

    private static boolean                          s_collectExtra = true;
    private static ThreadLocal<HttpServletRequest>  s_request      = new ThreadLocal<HttpServletRequest>();
    private static ThreadLocal<HttpServletResponse> s_response     = new ThreadLocal<HttpServletResponse>();

    @Override
    public void destroy() {
    }

    /**
     * @param request
     * @param response
     * @param chain
     * @throws IOException
     * @throws ServletException
     */
    public void doFilter(final HttpServletRequest request, final HttpServletResponse response, final FilterChain chain)
        throws IOException,
            ServletException {
        s_request.set(request);
        s_response.set(response);
        try {
            chain.doFilter(request, response);
        }
        finally {
            s_request.remove();
            s_response.remove();
        }
    }

    @Override
    public void doFilter(final ServletRequest request, final ServletResponse response, final FilterChain chain) throws IOException, ServletException {
        if(request instanceof HttpServletRequest && response instanceof HttpServletResponse) {
            doFilter((HttpServletRequest)request, (HttpServletResponse)response, chain);
        }
        else {
            doFilter(request, response, chain);
        }
    }

    @Override
    public void init(final FilterConfig config) throws ServletException {
        Konverge.addExtra(new Extra());
    }

}
