/*
 * Decompiled with CFR 0.152.
 */
package io.kk.vertx.kafka.relay;

import io.vertx.core.AbstractVerticle;
import io.vertx.core.json.JsonObject;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class BaseVerticle
extends AbstractVerticle {
    public static final String BOOTSTRAP_SERVERS = "bootstrap.servers";
    protected static final String ADDRESSES = "addresses";
    protected static final String KAFAK = "kafka";
    protected static final String END_KAFAK = ".kafka";
    protected static final String CLIENT_ID = "CLIENT_ID";
    protected static final String KFK_BSERVERS = "KFK_BSERVERS";
    private static final Logger LOG = LoggerFactory.getLogger(BaseVerticle.class);
    protected final List<String> bServers;
    protected List<String> addresses = new ArrayList<String>();

    public BaseVerticle(List<String> bServers) {
        this.bServers = Objects.requireNonNull(bServers);
    }

    protected Map<String, Object> loadConfig(JsonObject config) throws IOException {
        JsonObject kafkaConfig = config.getJsonObject(KAFAK);
        Objects.requireNonNull(kafkaConfig);
        return kafkaConfig.getMap();
    }

    protected void updateBServers(List<String> bServers, Map<String, Object> config) {
        if (bServers != null && !bServers.isEmpty()) {
            config.put(BOOTSTRAP_SERVERS, StringUtils.join(bServers, (String)","));
        } else {
            String bootServers = System.getenv(KFK_BSERVERS);
            if (StringUtils.isNotBlank((CharSequence)bootServers)) {
                config.put(BOOTSTRAP_SERVERS, bootServers);
            }
        }
    }

    protected Map<String, Object> updateConfig(Map<String, Object> config) {
        String clientId = System.getProperty(CLIENT_ID);
        if (StringUtils.isNotBlank((CharSequence)clientId)) {
            LOG.info("client id: {}", (Object)clientId);
            config.put(CLIENT_ID, clientId);
        }
        this.updateBServers(this.bServers, config);
        LOG.debug("Kafka Config : {}", config);
        return config;
    }
}

